/*
 * Decompiled with CFR 0.152.
 */
package org.simplejavamail.api.mailer;

import java.io.File;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import org.hazlewood.connor.bottema.emailaddress.EmailAddressCriteria;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.simplejavamail.api.internal.clisupport.model.Cli;
import org.simplejavamail.api.internal.clisupport.model.CliBuilderApiType;
import org.simplejavamail.api.mailer.CustomMailer;
import org.simplejavamail.api.mailer.Mailer;
import org.simplejavamail.api.mailer.config.LoadBalancingStrategy;
import org.simplejavamail.api.mailer.config.Pkcs12Config;

@Cli.BuilderApiNode(builderApiType=CliBuilderApiType.MAILER)
public interface MailerGenericBuilder<T extends MailerGenericBuilder<?>> {
    public static final boolean DEFAULT_TRUST_ALL_HOSTS = true;
    public static final boolean DEFAULT_VERIFY_SERVER_IDENTITY = true;
    public static final int DEFAULT_SESSION_TIMEOUT_MILLIS = 60000;
    public static final int DEFAULT_POOL_SIZE = 10;
    public static final int DEFAULT_POOL_KEEP_ALIVE_TIME = 1;
    public static final int DEFAULT_CONNECTIONPOOL_CORE_SIZE = 0;
    public static final int DEFAULT_CONNECTIONPOOL_MAX_SIZE = 4;
    public static final int DEFAULT_CONNECTIONPOOL_CLAIMTIMEOUT_MILLIS = Integer.MAX_VALUE;
    public static final int DEFAULT_CONNECTIONPOOL_EXPIREAFTER_MILLIS = 5000;
    public static final String DEFAULT_CONNECTIONPOOL_LOADBALANCING_STRATEGY = "ROUND_ROBIN";
    public static final int DEFAULT_PROXY_PORT = 1080;
    public static final int DEFAULT_PROXY_BRIDGE_PORT = 1081;
    public static final boolean DEFAULT_TRANSPORT_MODE_LOGGING_ONLY = false;
    public static final boolean DEFAULT_JAVAXMAIL_DEBUG = false;

    public T async();

    @Cli.ExcludeApi(reason="API is a subset of a more detailed API")
    public T withProxy(@Nullable String var1, @Nullable Integer var2);

    public T withProxy(@Nullable String var1, @Nullable Integer var2, @Nullable String var3, @Nullable String var4);

    @Cli.ExcludeApi(reason="API is a subset of a more details API")
    public T withProxyHost(@Nullable String var1);

    @Cli.ExcludeApi(reason="API is a subset of a more details API")
    public T withProxyPort(@Nullable Integer var1);

    @Cli.ExcludeApi(reason="API is a subset of a more details API")
    public T withProxyUsername(@Nullable String var1);

    @Cli.ExcludeApi(reason="API is a subset of a more details API")
    public T withProxyPassword(@Nullable String var1);

    public T withProxyBridgePort(@NotNull Integer var1);

    public T withDebugLogging(@NotNull Boolean var1);

    public T withSessionTimeout(@NotNull Integer var1);

    public T withEmailAddressCriteria(@NotNull EnumSet<EmailAddressCriteria> var1);

    @Cli.ExcludeApi(reason="delegated method contains CLI compatible arguments")
    public T signByDefaultWithSmime(@NotNull Pkcs12Config var1);

    public T signByDefaultWithSmime(@NotNull File var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @Cli.ExcludeApi(reason="Is duplicate API from CLI point of view")
    public T signByDefaultWithSmime(@NotNull InputStream var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    @Cli.ExcludeApi(reason="Is duplicate API from CLI point of view")
    public T signByDefaultWithSmime(@NotNull byte[] var1, @NotNull String var2, @NotNull String var3, @NotNull String var4);

    public T withExecutorService(@NotNull ExecutorService var1);

    public T withThreadPoolSize(@NotNull Integer var1);

    public T withThreadPoolKeepAliveTime(@NotNull Integer var1);

    public T withClusterKey(@NotNull UUID var1);

    public T withConnectionPoolCoreSize(@NotNull Integer var1);

    public T withConnectionPoolMaxSize(@NotNull Integer var1);

    public T withConnectionPoolClaimTimeoutMillis(@NotNull Integer var1);

    public T withConnectionPoolExpireAfterMillis(@NotNull Integer var1);

    public T withConnectionPoolLoadBalancingStrategy(@NotNull LoadBalancingStrategy var1);

    public T withTransportModeLoggingOnly(@NotNull Boolean var1);

    public T trustingSSLHosts(String ... var1);

    public T trustingAllHosts(boolean var1);

    public T verifyingServerIdentity(boolean var1);

    public T withProperties(@NotNull Properties var1);

    public T withProperties(@NotNull Map<String, String> var1);

    public T withProperty(@NotNull String var1, @Nullable Object var2);

    public T withCustomMailer(@NotNull CustomMailer var1);

    public T resetSessionTimeout();

    public T resetEmailAddressCriteria();

    public T resetExecutorService();

    public T resetThreadPoolSize();

    public T resetThreadPoolKeepAliveTime();

    public T resetTrustingAllHosts();

    public T resetVerifyingServerIdentity();

    public T resetClusterKey();

    public T resetConnectionPoolCoreSize();

    public T resetConnectionPoolMaxSize();

    public T resetConnectionPoolClaimTimeoutMillis();

    public T resetConnectionPoolExpireAfterMillis();

    public T resetConnectionPoolLoadBalancingStrategy();

    public T resetTransportModeLoggingOnly();

    public T clearProxy();

    public T clearEmailAddressCriteria();

    public T clearSignByDefaultWithSmime();

    public T clearTrustedSSLHosts();

    public T clearProperties();

    @Cli.ExcludeApi(reason="This API is specifically for Java use")
    public Mailer buildMailer();

    public boolean isAsync();

    @Nullable
    public String getProxyHost();

    @Nullable
    public Integer getProxyPort();

    @Nullable
    public String getProxyUsername();

    @Nullable
    public String getProxyPassword();

    @Nullable
    public Integer getProxyBridgePort();

    public boolean isDebugLogging();

    @Nullable
    public Integer getSessionTimeout();

    @Nullable
    public EnumSet<EmailAddressCriteria> getEmailAddressCriteria();

    @Nullable
    public Pkcs12Config getPkcs12ConfigForSmimeSigning();

    @Nullable
    public ExecutorService getExecutorService();

    @NotNull
    public Integer getThreadPoolSize();

    @NotNull
    public Integer getThreadPoolKeepAliveTime();

    @Nullable
    public UUID getClusterKey();

    @NotNull
    public Integer getConnectionPoolCoreSize();

    @NotNull
    public Integer getConnectionPoolMaxSize();

    @NotNull
    public Integer getConnectionPoolClaimTimeoutMillis();

    @NotNull
    public Integer getConnectionPoolExpireAfterMillis();

    @NotNull
    public LoadBalancingStrategy getConnectionPoolLoadBalancingStrategy();

    @Nullable
    public List<String> getSslHostsToTrust();

    public boolean isTrustAllSSLHost();

    public boolean isVerifyingServerIdentity();

    public boolean isTransportModeLoggingOnly();

    @Nullable
    public Properties getProperties();

    @Nullable
    public CustomMailer getCustomMailer();
}

