/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.validator;

import java.util.List;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.projecthusky.fhir.emed.ch.epr.validator.ValidationIssue;

public class ValidationResult {
    private final List<@NonNull ValidationIssue> issues;

    public ValidationResult(List<@NonNull ValidationIssue> issues) {
        this.issues = Objects.requireNonNull(issues);
    }

    public boolean isSuccessful() {
        return this.getErrors().isEmpty() && this.getFatals().isEmpty();
    }

    public List<@NonNull ValidationIssue> getIssues() {
        return this.issues;
    }

    public List<@NonNull ValidationIssue> getFatals() {
        return this.issues.stream().filter(message -> message.getSeverity() == OperationOutcome.IssueSeverity.FATAL).toList();
    }

    public List<@NonNull ValidationIssue> getErrors() {
        return this.issues.stream().filter(message -> message.getSeverity() == OperationOutcome.IssueSeverity.ERROR).toList();
    }

    public List<@NonNull ValidationIssue> getWarnings() {
        return this.issues.stream().filter(message -> message.getSeverity() == OperationOutcome.IssueSeverity.WARNING).toList();
    }

    public List<@NonNull ValidationIssue> getInformations() {
        return this.issues.stream().filter(message -> message.getSeverity() == OperationOutcome.IssueSeverity.INFORMATION).toList();
    }
}

