/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.validator;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ValidationIssue {
    public static final String OO_ISSUE_COL = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col";
    public static final String OO_ISSUE_LINE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line";
    public static final String OO_ISSUE_SOURCE = "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source";
    public static final String OO_ISSUE_MESSAGE_ID = "http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id";
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OperationOutcome.IssueSeverity severity;
    private // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OperationOutcome.IssueType type;
    private @Nullable String path;
    private @Nullable String message;
    private @Nullable Integer line;
    private @Nullable Integer column;
    private @Nullable String source;
    private @Nullable String messageId;

    public ValidationIssue() {
    }

    public ValidationIssue(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OperationOutcome.IssueSeverity severity, // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OperationOutcome.IssueType type, @Nullable String path, @Nullable String message, @Nullable Integer line, @Nullable Integer column, @Nullable String source, @Nullable String messageId) {
        this.severity = severity;
        this.type = type;
        this.path = path;
        this.message = message;
        this.line = line;
        this.column = column;
        this.source = source;
        this.messageId = messageId;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OperationOutcome.IssueSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OperationOutcome.IssueSeverity severity) {
        this.severity = severity;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OperationOutcome.IssueType getType() {
        return this.type;
    }

    public void setType(// Could not load outer class - annotation placement on inner may be incorrect
     @Nullable OperationOutcome.IssueType type) {
        this.type = type;
    }

    public @Nullable String getPath() {
        return this.path;
    }

    public void setPath(@Nullable String path) {
        this.path = path;
    }

    public @Nullable String getMessage() {
        return this.message;
    }

    public void setMessage(@Nullable String message) {
        this.message = message;
    }

    public @Nullable Integer getLine() {
        return this.line;
    }

    public void setLine(@Nullable Integer line) {
        this.line = line;
    }

    public @Nullable Integer getColumn() {
        return this.column;
    }

    public void setColumn(@Nullable Integer column) {
        this.column = column;
    }

    public @Nullable String getSource() {
        return this.source;
    }

    public void setSource(@Nullable String source) {
        this.source = source;
    }

    public @Nullable String getMessageId() {
        return this.messageId;
    }

    public void setMessageId(@Nullable String messageId) {
        this.messageId = messageId;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ValidationIssue)) {
            return false;
        }
        ValidationIssue that = (ValidationIssue)o;
        return this.severity == that.severity && this.type == that.type && Objects.equals(this.path, that.path) && Objects.equals(this.message, that.message) && Objects.equals(this.line, that.line) && Objects.equals(this.column, that.column) && Objects.equals(this.source, that.source) && Objects.equals(this.messageId, that.messageId);
    }

    public int hashCode() {
        return Objects.hash(this.severity, this.type, this.path, this.message, this.line, this.column, this.source, this.messageId);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.severity != null) {
            builder.append("[").append(this.severity.name()).append("] ");
        }
        if (this.type != null) {
            builder.append("[").append(this.type.name()).append("] ");
        }
        if (this.message != null) {
            builder.append(this.message).append(" ");
        }
        if (this.path != null) {
            builder.append(" in ").append(this.path).append(" ");
        }
        if (this.line != null || this.column != null) {
            builder.append(String.format("[%d:%d]", this.line, this.column)).append(" ");
        }
        if (this.source != null) {
            builder.append("from source ").append(this.source).append(" ");
        }
        if (this.messageId != null) {
            builder.append("from messageId ").append(this.messageId);
        }
        return builder.toString();
    }
}

