/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.validator;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedEprDosage;
import org.projecthusky.fhir.emed.ch.epr.enums.TimingEventAmbu;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprDocumentDis;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprMedicationDispenseDis;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprDocumentMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprMedicationStatementMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprDocumentPadv;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprDocumentPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pmlc.ChEmedEprDocumentPmlc;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprDocumentPre;
import org.projecthusky.fhir.emed.ch.epr.validator.ValidationIssue;

class LogicValidator {
    public static final String SOURCE = "LogicValidator";

    LogicValidator() {
    }

    public List<@NonNull ValidationIssue> validate(ChEmedEprDocument document) {
        ArrayList<ValidationIssue> issues = new ArrayList<ValidationIssue>(0);
        if (document instanceof ChEmedEprDocumentMtp) {
            ChEmedEprDocumentMtp mtpDocument = (ChEmedEprDocumentMtp)document;
            ChEmedEprMedicationStatementMtp mtpEntry = mtpDocument.resolveComposition().resolveMedicationStatement();
            this.validateDosages(mtpEntry.resolveBaseDosage(), mtpEntry.resolveAdditionalDosage(), issues);
        } else if (document instanceof ChEmedEprDocumentPre) {
            ChEmedEprDocumentPre preDocument = (ChEmedEprDocumentPre)document;
        } else if (document instanceof ChEmedEprDocumentDis) {
            ChEmedEprDocumentDis disDocument = (ChEmedEprDocumentDis)document;
            ChEmedEprMedicationDispenseDis disEntry = disDocument.resolveComposition().resolveMedicationDispense();
            this.validateDosages(disEntry.resolveBaseDosage(), disEntry.resolveAdditionalDosage(), issues);
        } else if (document instanceof ChEmedEprDocumentPadv) {
            ChEmedEprDocumentPadv padvDocument = (ChEmedEprDocumentPadv)document;
        } else if (document instanceof ChEmedEprDocumentPml) {
            ChEmedEprDocumentPml pmlDocument = (ChEmedEprDocumentPml)document;
        } else if (document instanceof ChEmedEprDocumentPmlc) {
            ChEmedEprDocumentPmlc chEmedEprDocumentPmlc = (ChEmedEprDocumentPmlc)document;
        }
        return issues;
    }

    public void validateDosages(ChEmedEprDosage baseDosage, List<@NonNull ChEmedEprDosage> additionalDosages, List<@NonNull ValidationIssue> issues) {
        if (additionalDosages.isEmpty()) {
            return;
        }
        if (!baseDosage.hasDoseAndRate()) {
            issues.add(LogicValidator.createError("Additional dosages shall not be present if the main dosage has no dose or rate"));
        }
        EnumSet<TimingEventAmbu> timingEventSeen = EnumSet.noneOf(TimingEventAmbu.class);
        for (TimingEventAmbu timingEvent : baseDosage.resolveWhen()) {
            if (timingEventSeen.contains((Object)timingEvent)) {
                issues.add(LogicValidator.createError("The timing event '" + timingEvent.getCodeValue() + "' shall not appear multiple times"));
            }
            timingEventSeen.add(timingEvent);
        }
        for (ChEmedEprDosage additionDosage : additionalDosages) {
            for (TimingEventAmbu timingEvent : additionDosage.resolveWhen()) {
                if (timingEventSeen.contains((Object)timingEvent)) {
                    issues.add(LogicValidator.createError("The timing event '" + timingEvent.getCodeValue() + "' shall not appear multiple times"));
                }
                timingEventSeen.add(timingEvent);
            }
        }
    }

    protected static ValidationIssue createError(String message) {
        return new ValidationIssue(OperationOutcome.IssueSeverity.ERROR, null, null, message, null, null, SOURCE, null);
    }
}

