/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.validator;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.support.ConceptValidationOptions;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.context.support.ValidationSupportContext;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.common.hapi.validation.support.BaseValidationSupport;
import org.hl7.fhir.instance.model.api.IBaseResource;

@ThreadSafe
public class FakeTerminologyServiceValidationSupport
extends BaseValidationSupport
implements IValidationSupport {
    private final List<String> supportedCodeSystems = new ArrayList<String>(2);

    public FakeTerminologyServiceValidationSupport(FhirContext theFhirContext) {
        super(theFhirContext);
        this.supportedCodeSystems.add("http://snomed.info/sct");
        this.supportedCodeSystems.add("http://loinc.org");
    }

    public List<String> getSupportedCodeSystems() {
        return this.supportedCodeSystems;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IValidationSupport.CodeValidationResult validateCode(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, String theValueSetUrl) {
        return this.createSuccessfulCodeValidationResult(theCode, theDisplay);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable IValidationSupport.CodeValidationResult validateCodeInValueSet(ValidationSupportContext theValidationSupportContext, ConceptValidationOptions theOptions, String theCodeSystem, String theCode, String theDisplay, @NonNull IBaseResource theValueSet) {
        return this.createSuccessfulCodeValidationResult(theCode, theDisplay);
    }

    public boolean isCodeSystemSupported(ValidationSupportContext theValidationSupportContext, String theSystem) {
        return this.supportedCodeSystems.contains(theSystem);
    }

    protected IValidationSupport.CodeValidationResult createSuccessfulCodeValidationResult(String theCode, String theDisplay) {
        IValidationSupport.CodeValidationResult result = new IValidationSupport.CodeValidationResult();
        result.setCode(theCode);
        result.setDisplay(theDisplay);
        return result;
    }
}

