/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.validator;

import ch.ahdis.matchbox.engine.MatchboxEngine;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.stream.Collectors;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.utils.EOperationOutcome;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.validator.LogicValidator;
import org.projecthusky.fhir.emed.ch.epr.validator.ValidationIssue;
import org.projecthusky.fhir.emed.ch.epr.validator.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChEmedEprValidator {
    private static final Logger log = LoggerFactory.getLogger(ChEmedEprValidator.class);
    private final MatchboxEngine matchboxEngine;
    private final LogicValidator logicValidator = new LogicValidator();

    public ChEmedEprValidator() throws IOException, URISyntaxException {
        this.matchboxEngine = new MatchboxEngine.MatchboxEngineBuilder().getEngineR4();
        log.debug("Start loading IGs");
        this.matchboxEngine.loadPackage(this.getClass().getResourceAsStream("/package/ihe.formatcode.fhir#1.1.0.tgz"));
        this.matchboxEngine.loadPackage(this.getClass().getResourceAsStream("/package/ch.fhir.ig.ch-epr-term#20230523.tgz"));
        this.matchboxEngine.loadPackage(this.getClass().getResourceAsStream("/package/ch.fhir.ig.ch-core#20230523.tgz"));
        this.matchboxEngine.loadPackage(this.getClass().getResourceAsStream("/package/ch.fhir.ig.ch-emed#20230523.tgz"));
        this.matchboxEngine.loadPackage(this.getClass().getResourceAsStream("/package/ch.cara.fhir.epr.emed#20230523.tgz"));
        log.debug("Stop loading IGs");
    }

    public ValidationResult validateDocumentBundle(InputStream documentStream, ChEmedEprDocument document, Manager.FhirFormat streamFormat) throws EOperationOutcome, IOException {
        OperationOutcome outcome = this.matchboxEngine.validate(documentStream, streamFormat, this.getProfileUrl(document.getEmedType()));
        ValidationResult result = new ValidationResult(outcome.getIssue().stream().map(this::mapIssue).collect(Collectors.toList()));
        if (!result.isSuccessful()) {
            return result;
        }
        result.getIssues().addAll(this.logicValidator.validate(document));
        return result;
    }

    protected String getProfileUrl(EmedDocumentType type) {
        return switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case EmedDocumentType.MTP -> "https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationtreatmentplan";
            case EmedDocumentType.PRE -> "https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationprescription";
            case EmedDocumentType.DIS -> "https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationdispense";
            case EmedDocumentType.PADV -> "https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-pharmaceuticaladvice";
            case EmedDocumentType.PML -> "https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationlist";
            case EmedDocumentType.PMLC -> "https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationcard";
        };
    }

    protected ValidationIssue mapIssue(OperationOutcome.OperationOutcomeIssueComponent component) {
        Integer line = null;
        Integer column = null;
        String source = null;
        String messageId = null;
        for (Extension extension : component.getExtension()) {
            switch (extension.getUrl()) {
                case "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-col": {
                    column = (Integer)extension.castToInteger((Base)extension.getValue()).getValue();
                    break;
                }
                case "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-line": {
                    line = (Integer)extension.castToInteger((Base)extension.getValue()).getValue();
                    break;
                }
                case "http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-source": {
                    source = (String)extension.castToString((Base)extension.getValue()).getValue();
                    break;
                }
                case "http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id": {
                    messageId = (String)extension.castToString((Base)extension.getValue()).getValue();
                }
            }
        }
        return new ValidationIssue(component.getSeverity(), component.getCode(), component.hasExpression() ? ((StringType)component.getExpression().get(0)).getValueNotNull() : null, component.hasDetails() && component.getDetails().hasText() ? component.getDetails().getText() : null, line, column, source, messageId);
    }
}

