/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.service;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.EncodingEnum;
import java.util.ArrayList;
import javax.annotation.concurrent.ThreadSafe;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Bundle;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDevice;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprMedication;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprOrganization;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPatient;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitioner;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprRelatedPerson;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprCompositionDis;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprDocumentDis;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprMedicationDis;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprMedicationDispenseDis;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprCompositionMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprDocumentMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprMedicationStatementMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprCompositionPadv;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprDocumentPadv;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprMedicationStatementChanged;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprObservationPadv;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprCompositionPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprDocumentPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprMedicationDispensePml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprMedicationRequestPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprMedicationStatementPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprObservationPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pmlc.ChEmedEprCompositionPmlc;
import org.projecthusky.fhir.emed.ch.epr.resource.pmlc.ChEmedEprDocumentPmlc;
import org.projecthusky.fhir.emed.ch.epr.resource.pmlc.ChEmedEprMedicationStatementPmlc;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprCompositionPre;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprDocumentPre;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprMedicationRequestPre;

@ThreadSafe
public class ChEmedEprParser {
    private final FhirContext context;

    public ChEmedEprParser(@Nullable FhirContext fhirR4Context) {
        if (fhirR4Context == null || fhirR4Context.getVersion().getVersion() != FhirVersionEnum.R4) {
            throw new IllegalArgumentException("ChEmedEprParser requires a FHIR R4 context");
        }
        this.context = fhirR4Context;
    }

    public <T extends ChEmedEprDocument> T parse(String resource, EmedDocumentType type) {
        EncodingEnum encoding = EncodingEnum.detectEncodingNoDefault((String)resource);
        if (encoding == null) {
            throw new InvalidEmedContentException("Unable to determine the FHIR resource encoding");
        }
        IBaseResource parsed = this.getParser(encoding, type).parseResource(resource);
        if (parsed.getClass().getSuperclass() == ChEmedEprDocument.class) {
            ChEmedEprDocument document = (ChEmedEprDocument)parsed;
            return (T)((Object)document);
        }
        throw new InvalidEmedContentException("The given resource isn't a CH-EMED Document");
    }

    public String serialize(Bundle documentBundle, EncodingEnum encoding) {
        return this.getParser(encoding, null).encodeResourceToString((IBaseResource)documentBundle);
    }

    public String serializePrettyPrint(Bundle documentBundle, EncodingEnum encoding) {
        return this.getParser(encoding, null).setPrettyPrint(true).encodeResourceToString((IBaseResource)documentBundle);
    }

    protected IParser getParser(EncodingEnum encoding, @Nullable EmedDocumentType type) {
        IParser parser;
        switch (encoding) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case JSON: {
                IParser iParser = this.context.newJsonParser();
                break;
            }
            case XML: {
                IParser iParser = this.context.newXmlParser();
                break;
            }
            case NDJSON: {
                IParser iParser = this.context.newNDJsonParser();
                break;
            }
            case RDF: {
                IParser iParser = parser = this.context.newRDFParser();
            }
        }
        if (type == null) {
            return parser;
        }
        ArrayList<Class<ChEmedEprMedicationStatementPmlc>> preferTypes = new ArrayList<Class<ChEmedEprMedicationStatementPmlc>>(10);
        preferTypes.add(ChEmedEprDevice.class);
        preferTypes.add(ChEmedEprPatient.class);
        preferTypes.add(ChEmedEprOrganization.class);
        preferTypes.add(ChEmedEprPractitioner.class);
        preferTypes.add(ChEmedEprPractitionerRole.class);
        preferTypes.add(ChEmedEprRelatedPerson.class);
        preferTypes.add(ChEmedEprMedication.class);
        switch (type) {
            case MTP: {
                preferTypes.add(ChEmedEprDocumentMtp.class);
                preferTypes.add(ChEmedEprCompositionMtp.class);
                preferTypes.add(ChEmedEprMedicationStatementMtp.class);
                break;
            }
            case PRE: {
                preferTypes.add(ChEmedEprDocumentPre.class);
                preferTypes.add(ChEmedEprCompositionPre.class);
                preferTypes.add(ChEmedEprMedicationRequestPre.class);
                break;
            }
            case DIS: {
                preferTypes.add(ChEmedEprDocumentDis.class);
                preferTypes.add(ChEmedEprCompositionDis.class);
                preferTypes.add(ChEmedEprMedicationDispenseDis.class);
                preferTypes.add(ChEmedEprMedicationDis.class);
                break;
            }
            case PADV: {
                preferTypes.add(ChEmedEprDocumentPadv.class);
                preferTypes.add(ChEmedEprCompositionPadv.class);
                preferTypes.add(ChEmedEprObservationPadv.class);
                preferTypes.add(ChEmedEprMedicationStatementChanged.class);
                preferTypes.add(ChEmedEprMedicationRequestPre.class);
                break;
            }
            case PML: {
                preferTypes.add(ChEmedEprDocumentPml.class);
                preferTypes.add(ChEmedEprCompositionPml.class);
                preferTypes.add(ChEmedEprMedicationStatementPml.class);
                preferTypes.add(ChEmedEprMedicationRequestPml.class);
                preferTypes.add(ChEmedEprMedicationDispensePml.class);
                preferTypes.add(ChEmedEprObservationPml.class);
                break;
            }
            case PMLC: {
                preferTypes.add(ChEmedEprDocumentPmlc.class);
                preferTypes.add(ChEmedEprCompositionPmlc.class);
                preferTypes.add(ChEmedEprMedicationStatementPmlc.class);
            }
        }
        parser.setPreferTypes(preferTypes);
        return parser;
    }
}

