/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pre;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.UUID;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprCompositionPre;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprMedicationRequestPre;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationprescription")
public class ChEmedEprDocumentPre
extends ChEmedEprDocument {
    private static final long serialVersionUID = 2718367416326416761L;

    public ChEmedEprDocumentPre() {
    }

    public ChEmedEprDocumentPre(UUID documentId, Instant timestamp) {
        super(documentId, timestamp);
    }

    @Override
    public EmedDocumentType getEmedType() {
        return EmedDocumentType.PRE;
    }

    public boolean hasCompositionEntry() {
        return this.getEntryByResourceType(ChEmedEprCompositionPre.class) != null;
    }

    @Override
    public Bundle.BundleEntryComponent getCompositionEntry() {
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionPre.class);
        if (entry == null) {
            entry = new Bundle.BundleEntryComponent();
            this.getEntry().add(0, entry);
        }
        return entry;
    }

    @Override
    @ExpectsValidResource
    public ChEmedEprCompositionPre resolveComposition() {
        Resource resource;
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionPre.class);
        if (entry != null && (resource = entry.getResource()) instanceof ChEmedEprCompositionPre) {
            ChEmedEprCompositionPre composition = (ChEmedEprCompositionPre)resource;
            return composition;
        }
        throw new InvalidEmedContentException("The ChEmedEprCompositionPre is missing in the document Bundle");
    }

    public ChEmedEprDocumentPre addMedicationRequest(ChEmedEprMedicationRequestPre medicationRequest) {
        this.addEntry().setFullUrl(medicationRequest.getIdentifierFirstRep().getValue()).setResource((Resource)medicationRequest);
        return this;
    }

    public ChEmedEprDocumentPre setComposition(ChEmedEprCompositionPre composition) {
        this.getCompositionEntry().setFullUrl(composition.getIdentifier().getValue()).setResource((Resource)composition);
        return this;
    }

    public ChEmedEprDocumentPre copy() {
        ChEmedEprDocumentPre copy = new ChEmedEprDocumentPre();
        this.copyValues(copy);
        return copy;
    }
}

