/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pre;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.enums.CompositionTitle;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprComposition;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprMedicationRequestPre;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-composition-medicationprescription")
public class ChEmedEprCompositionPre
extends ChEmedEprComposition {
    public ChEmedEprCompositionPre() {
    }

    public ChEmedEprCompositionPre(UUID compositionId, Instant date, LanguageCode language) {
        super(compositionId, date, language);
        this.getType().addCoding(new Coding("http://snomed.info/sct", "761938008", "Medical prescription record (record artifact)"));
        this.getType().addCoding(new Coding("http://loinc.org", "57833-6", "Prescription for medication"));
        this.setTitle(CompositionTitle.PRE.getDisplayName(language));
    }

    @ExpectsValidResource
    public List<DomainResource> resolveAuthors() throws InvalidEmedContentException {
        if (!this.hasAuthor()) {
            throw new InvalidEmedContentException("The composition requires at least one author.");
        }
        ArrayList<DomainResource> authors = new ArrayList<DomainResource>();
        for (Reference reference : this.getAuthor()) {
            IBaseResource resource = reference.getResource();
            if (resource instanceof ChEmedEprPractitionerRole || resource instanceof ChCorePatientEpr || resource instanceof Device) {
                authors.add((DomainResource)resource);
                continue;
            }
            throw new InvalidEmedContentException("An author is invalid.");
        }
        return authors;
    }

    @ExpectsValidResource
    public Resource resolveMainHumanAuthor() {
        return (Resource)this.resolveAuthors().stream().filter(author -> author instanceof ChEmedEprPractitionerRole || author instanceof ChCorePatientEpr).findFirst().orElseThrow(() -> new InvalidEmedContentException(""));
    }

    public Composition.SectionComponent getPrescriptionSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("57828-6");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "57828-6", "Prescriptions"));
        }
        return section;
    }

    @ExpectsValidResource
    public List<ChEmedEprMedicationRequestPre> resolveMedicationRequests() throws InvalidEmedContentException {
        Composition.SectionComponent section = this.getPrescriptionSection();
        if (!section.hasEntry()) {
            throw new InvalidEmedContentException("The section has no entries");
        }
        ArrayList<ChEmedEprMedicationRequestPre> medicationRequests = new ArrayList<ChEmedEprMedicationRequestPre>(0);
        for (Reference entry : section.getEntry()) {
            IBaseResource resource = entry.getResource();
            if (resource instanceof ChEmedEprMedicationRequestPre) {
                ChEmedEprMedicationRequestPre medicationRequest = (ChEmedEprMedicationRequestPre)resource;
                medicationRequests.add(medicationRequest);
                continue;
            }
            throw new InvalidEmedContentException("The prescription section has a non ChEmedEprMedicationRequestPre resource");
        }
        return medicationRequests;
    }

    public Composition.SectionComponent getAnnotationSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("48767-8");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "48767-8", "Annotation comment"));
        }
        return section;
    }

    public boolean hasPrescriptionSection() {
        return this.getSectionByLoincCode("57828-6") != null;
    }

    public boolean hasAnnotationSection() {
        return this.getSectionByLoincCode("48767-8") != null;
    }

    public ChEmedEprCompositionPre addAuthor(ChEmedEprPractitionerRole author) {
        this.addAuthor(References.createReference((Resource)author));
        return this;
    }

    public ChEmedEprCompositionPre addAuthor(ChCorePatientEpr author) {
        this.addAuthor(References.createReference((Resource)author));
        return this;
    }

    public ChEmedEprCompositionPre addMedicationRequest(ChEmedEprMedicationRequestPre medicationRequest) {
        List entry = this.getPrescriptionSection().getEntry();
        Reference reference = References.createReference((Resource)medicationRequest);
        if (entry.isEmpty()) {
            entry.add(reference);
        } else {
            entry.set(0, reference);
        }
        return this;
    }

    public ChEmedEprCompositionPre copy() {
        ChEmedEprCompositionPre copy = new ChEmedEprCompositionPre();
        this.copyValues(copy);
        return copy;
    }
}

