/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pmlc;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.model.common.Author;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprMedicationStatement;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtPrescription;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtTreatmentPlan;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-medicationstatement-card")
public class ChEmedEprMedicationStatementPmlc
extends ChEmedEprMedicationStatement {
    @Child(name="treatmentPlan", min=1)
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-treatmentplan", definedLocally=false)
    protected @Nullable ChEmedExtTreatmentPlan treatmentPlan;
    @Child(name="prescription")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-prescription", definedLocally=false)
    protected @Nullable ChEmedExtPrescription prescription;
    @Child(name="authorDocument")
    @Extension(url="http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-author")
    protected @Nullable Reference authorDocument;

    public ChEmedEprMedicationStatementPmlc() {
    }

    public ChEmedEprMedicationStatementPmlc(UUID entryUuid) {
        super(entryUuid);
    }

    public ChEmedExtTreatmentPlan getTreatmentPlanElement() {
        if (this.treatmentPlan == null) {
            this.treatmentPlan = new ChEmedExtTreatmentPlan();
        }
        return this.treatmentPlan;
    }

    public ChEmedExtPrescription getPrescriptionElement() {
        if (this.prescription == null) {
            this.prescription = new ChEmedExtPrescription();
        }
        return this.prescription;
    }

    public Reference getAuthorDocumentElement() {
        if (this.authorDocument == null) {
            this.authorDocument = new Reference();
        }
        return this.authorDocument;
    }

    @ExpectsValidResource
    public @Nullable DomainResource resolveAuthorDocument() throws InvalidEmedContentException {
        IBaseResource resource = this.getAuthorDocumentElement().getResource();
        if (resource == null) {
            return null;
        }
        if (resource instanceof ChCorePatientEpr || resource instanceof ChEmedEprPractitionerRole) {
            return (DomainResource)resource;
        }
        throw new InvalidEmedContentException("The last author of the original document is invalid");
    }

    public ChEmedEprMedicationStatementPmlc setAuthorDocument(IBaseResource author) {
        this.authorDocument = References.createReference((Resource)author);
        return this;
    }

    public ChEmedEprMedicationStatementPmlc setTreatmentPlanElement(ChEmedExtTreatmentPlan treatmentPlan) {
        this.treatmentPlan = treatmentPlan;
        return this;
    }

    public ChEmedEprMedicationStatementPmlc setTreatmentPlanElement(ChEmedExtPrescription prescription) {
        this.prescription = prescription;
        return this;
    }

    public boolean hasAuthorDocument() {
        return this.authorDocument != null && this.authorDocument.getResource() != null;
    }

    public boolean hasTreatmentPlan() {
        return this.treatmentPlan != null && !this.treatmentPlan.isEmpty();
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    @Override
    @ExpectsValidResource
    public Author resolveInformationSource() {
        if (!this.hasInformationSource()) {
            throw new InvalidEmedContentException("The information source is missing.");
        }
        return new Author(this.getInformationSource().getResource());
    }

    public ChEmedEprMedicationStatementPmlc copy() {
        ChEmedEprMedicationStatementPmlc copy = new ChEmedEprMedicationStatementPmlc();
        this.copyValues(copy);
        return copy;
    }

    @Override
    public void copyValues(MedicationStatement dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprMedicationStatementPmlc) {
            ChEmedEprMedicationStatementPmlc als = (ChEmedEprMedicationStatementPmlc)dst;
            als.treatmentPlan = this.treatmentPlan == null ? null : this.treatmentPlan.copy();
            als.authorDocument = this.authorDocument == null ? null : this.authorDocument.copy();
        }
    }
}

