/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pmlc;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.UUID;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.resource.pmlc.ChEmedEprCompositionPmlc;
import org.projecthusky.fhir.emed.ch.epr.resource.pmlc.ChEmedEprMedicationStatementPmlc;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationcard")
public class ChEmedEprDocumentPmlc
extends ChEmedEprDocument {
    private static final long serialVersionUID = 9089732845195396799L;

    public ChEmedEprDocumentPmlc() {
    }

    public ChEmedEprDocumentPmlc(UUID documentId, Instant timestamp) {
        super(documentId, timestamp);
    }

    @Override
    public EmedDocumentType getEmedType() {
        return EmedDocumentType.PMLC;
    }

    public boolean hasCompositionEntry() {
        return this.getEntryByResourceType(ChEmedEprCompositionPmlc.class) != null;
    }

    @Override
    public Bundle.BundleEntryComponent getCompositionEntry() {
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionPmlc.class);
        if (entry == null) {
            entry = new Bundle.BundleEntryComponent();
            this.getEntry().add(0, entry);
        }
        return entry;
    }

    @Override
    @ExpectsValidResource
    public ChEmedEprCompositionPmlc resolveComposition() {
        Resource resource;
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionPmlc.class);
        if (entry != null && (resource = entry.getResource()) instanceof ChEmedEprCompositionPmlc) {
            ChEmedEprCompositionPmlc composition = (ChEmedEprCompositionPmlc)resource;
            return composition;
        }
        throw new InvalidEmedContentException("The ChEmedEprCompositionPmlc is missing in the document Bundle");
    }

    public Bundle.BundleEntryComponent addEntryResource(Resource resource) {
        return this.addEntry().setResource(resource);
    }

    public ChEmedEprDocumentPmlc addMedicationStatement(ChEmedEprMedicationStatementPmlc medicationStatement) {
        this.addEntry().setFullUrl(medicationStatement.getIdentifierFirstRep().getValue()).setResource((Resource)medicationStatement);
        return this;
    }

    public ChEmedEprDocumentPmlc setComposition(ChEmedEprCompositionPmlc composition) {
        this.getCompositionEntry().setFullUrl(composition.getIdentifier().getValue()).setResource((Resource)composition);
        return this;
    }

    public ChEmedEprDocumentPmlc copy() {
        ChEmedEprDocumentPmlc copy = new ChEmedEprDocumentPmlc();
        this.copyValues(copy);
        return copy;
    }
}

