/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pmlc;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.enums.CompositionTitle;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprComposition;
import org.projecthusky.fhir.emed.ch.epr.resource.pmlc.ChEmedEprMedicationStatementPmlc;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-composition-medicationcard")
public class ChEmedEprCompositionPmlc
extends ChEmedEprComposition {
    public ChEmedEprCompositionPmlc() {
    }

    public ChEmedEprCompositionPmlc(UUID compositionId, Instant date, LanguageCode language) {
        super(compositionId, date, language);
        this.getType().addCoding(new Coding("http://snomed.info/sct", "736378000", "Medication management plan (record artifact)"));
        this.setTitle(CompositionTitle.PMLC.getDisplayName(language));
    }

    @ExpectsValidResource
    public Device resolveAuthor() throws InvalidEmedContentException {
        if (!this.hasAuthor()) {
            throw new InvalidEmedContentException("The composition requires an author.");
        }
        IBaseResource iBaseResource = this.getAuthorFirstRep().getResource();
        if (iBaseResource instanceof Device) {
            Device device = (Device)iBaseResource;
            return device;
        }
        throw new InvalidEmedContentException("The author is not a device.");
    }

    public Composition.SectionComponent getAnnotationSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("48767-8");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "48767-8", "Annotation comment"));
            section.setTitle("Comment");
        }
        return section;
    }

    public Composition.SectionComponent getCardSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("10160-0");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "10160-0", "History of medication use"));
            section.setTitle("Medication List");
        }
        return section;
    }

    @Override
    public Composition.SectionComponent getOriginalRepresentationSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("55108-5");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "55108-5", "Clinical presentation"));
            section.setTitle("Original representation");
        }
        return section;
    }

    @ExpectsValidResource
    public List<ChEmedEprMedicationStatementPmlc> resolveMedicationStatements() throws InvalidEmedContentException {
        Composition.SectionComponent section = this.getCardSection();
        ArrayList<ChEmedEprMedicationStatementPmlc> medicationStatementList = new ArrayList<ChEmedEprMedicationStatementPmlc>();
        for (Reference entry : section.getEntry()) {
            IBaseResource resource = entry.getResource();
            if (resource instanceof ChEmedEprMedicationStatementPmlc) {
                ChEmedEprMedicationStatementPmlc medicationStatementPmlc = (ChEmedEprMedicationStatementPmlc)resource;
                medicationStatementList.add(medicationStatementPmlc);
                continue;
            }
            throw new InvalidEmedContentException("The section references an invalid resource");
        }
        return medicationStatementList;
    }

    public boolean hasCardSection() {
        return this.getSectionByLoincCode("10160-0") != null;
    }

    public boolean hasAnnotationSection() {
        return this.getSectionByLoincCode("48767-8") != null;
    }

    public ChEmedEprCompositionPmlc addAuthor(Device author) {
        this.addAuthor(References.createReference((Resource)author));
        return this;
    }

    public ChEmedEprCompositionPmlc copy() {
        ChEmedEprCompositionPmlc copy = new ChEmedEprCompositionPmlc();
        this.copyValues(copy);
        return copy;
    }
}

