/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pml;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedPadvEntryType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprObservation;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtPharmaceuticalAdvice;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-observation-list")
public class ChEmedEprObservationPml
extends ChEmedEprObservation {
    @Child(name="authorDocument")
    @Extension(url="http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-author")
    protected @Nullable Reference authorDocument;
    @Child(name="parentDocument")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-pharmaceuticaladvice")
    protected @Nullable ChEmedExtPharmaceuticalAdvice parentDocument;

    public ChEmedEprObservationPml() {
    }

    public ChEmedEprObservationPml(UUID entryUuid, EmedPadvEntryType padvType) {
        super(entryUuid, padvType);
    }

    @ExpectsValidResource
    public ChEmedEprPractitionerRole resolvePerformer() throws InvalidEmedContentException {
        if (!this.hasPerformer()) {
            throw new InvalidEmedContentException("The the author and her/his organization of the medical decision is missing.");
        }
        IBaseResource resource = this.getPerformerFirstRep().getResource();
        if (resource instanceof ChEmedEprPractitionerRole) {
            ChEmedEprPractitionerRole chEmedEprPractitionerRole = (ChEmedEprPractitionerRole)resource;
            return chEmedEprPractitionerRole;
        }
        throw new InvalidEmedContentException("The author and her/his organization of the medical decision resource isn't of the right type.");
    }

    public Reference getAuthorDocumentElement() {
        if (this.authorDocument == null) {
            this.authorDocument = new Reference();
        }
        return this.authorDocument;
    }

    @ExpectsValidResource
    public @Nullable DomainResource getAuthorDocument() throws InvalidEmedContentException {
        IBaseResource resource = this.getAuthorDocumentElement().getResource();
        if (resource == null) {
            return null;
        }
        if (resource instanceof ChCorePatientEpr || resource instanceof ChEmedEprPractitionerRole) {
            return (DomainResource)resource;
        }
        throw new InvalidEmedContentException("The last author of the original document is invalid");
    }

    public ChEmedEprObservationPml setAuthorDocument(IBaseResource author) {
        this.authorDocument = References.createReference((Resource)author);
        return this;
    }

    public ChEmedEprObservationPml setPerformer(ChEmedEprPractitionerRole performer) {
        Reference reference = References.createReference((Resource)performer);
        if (this.getPerformer().isEmpty()) {
            this.addPerformer(reference);
        } else {
            this.getPerformer().set(0, reference);
        }
        return this;
    }

    public ChEmedEprObservationPml setPerformer(ChCorePatientEpr performer) {
        Reference reference = References.createReference((Resource)performer);
        if (this.getPerformer().isEmpty()) {
            this.addPerformer(reference);
        } else {
            this.getPerformer().set(0, reference);
        }
        return this;
    }

    public ChEmedEprObservationPml setPerformer(RelatedPerson performer) {
        Reference reference = References.createReference((Resource)performer);
        if (this.getPerformer().isEmpty()) {
            this.addPerformer(reference);
        } else {
            this.getPerformer().set(0, reference);
        }
        return this;
    }

    public boolean hasAuthorDocument() {
        return this.authorDocument != null && this.authorDocument.getResource() != null;
    }

    public ChEmedExtPharmaceuticalAdvice getParentDocumentElement() {
        if (this.parentDocument == null) {
            this.parentDocument = new ChEmedExtPharmaceuticalAdvice();
        }
        return this.parentDocument;
    }

    public ChEmedEprObservationPml setParentDocumentElement(ChEmedExtPharmaceuticalAdvice parentDocument) {
        this.parentDocument = parentDocument;
        return this;
    }

    public boolean hasParentDocument() {
        return this.parentDocument != null && !this.parentDocument.isEmpty();
    }

    public ChEmedEprObservationPml copy() {
        ChEmedEprObservationPml copy = new ChEmedEprObservationPml();
        this.copyValues(copy);
        return copy;
    }

    @Override
    public void copyValues(Observation dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprObservationPml) {
            ChEmedEprObservationPml als = (ChEmedEprObservationPml)dst;
            als.authorDocument = this.authorDocument == null ? null : this.authorDocument.copy();
            als.parentDocument = this.parentDocument == null ? null : this.parentDocument.copy();
        }
    }
}

