/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pml;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprMedicationStatement;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtTreatmentPlan;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-medicationstatement-list")
public class ChEmedEprMedicationStatementPml
extends ChEmedEprMedicationStatement {
    @Child(name="authorDocument")
    @Extension(url="http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-author")
    protected @Nullable Reference authorDocument;
    @Child(name="parentDocument")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-treatmentplan")
    protected @Nullable ChEmedExtTreatmentPlan parentDocument;

    public ChEmedEprMedicationStatementPml() {
    }

    public ChEmedEprMedicationStatementPml(UUID entryUuid) {
        super(entryUuid);
    }

    public Reference getAuthorDocumentElement() {
        if (this.authorDocument == null) {
            this.authorDocument = new Reference();
        }
        return this.authorDocument;
    }

    @ExpectsValidResource
    public @Nullable DomainResource getAuthorDocument() throws InvalidEmedContentException {
        IBaseResource resource = this.getAuthorDocumentElement().getResource();
        if (resource == null) {
            return null;
        }
        if (resource instanceof ChCorePatientEpr || resource instanceof ChEmedEprPractitionerRole) {
            return (DomainResource)resource;
        }
        throw new InvalidEmedContentException("The last author of the original document is invalid");
    }

    public boolean hasAuthorDocument() {
        return this.authorDocument != null && this.authorDocument.getResource() != null;
    }

    public ChEmedEprMedicationStatementPml setAuthorDocument(IBaseResource author) {
        this.authorDocument = References.createReference((Resource)author);
        return this;
    }

    public ChEmedExtTreatmentPlan getParentDocumentElement() {
        if (this.parentDocument == null) {
            this.parentDocument = new ChEmedExtTreatmentPlan();
        }
        return this.parentDocument;
    }

    public ChEmedEprMedicationStatementPml setParentDocumentElement(ChEmedExtTreatmentPlan parentDocument) {
        this.parentDocument = parentDocument;
        return this;
    }

    public boolean hasParentDocument() {
        return this.parentDocument != null && !this.parentDocument.isEmpty();
    }

    public ChEmedEprMedicationStatementPml copy() {
        ChEmedEprMedicationStatementPml copy = new ChEmedEprMedicationStatementPml();
        this.copyValues(copy);
        return copy;
    }

    @Override
    public void copyValues(MedicationStatement dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprMedicationStatementPml) {
            ChEmedEprMedicationStatementPml als = (ChEmedEprMedicationStatementPml)dst;
            als.authorDocument = this.authorDocument == null ? null : this.authorDocument.copy();
            als.parentDocument = this.parentDocument == null ? null : this.parentDocument.copy();
        }
    }
}

