/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pml;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprMedicationRequest;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtPrescription;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-medicationrequest-list")
public class ChEmedEprMedicationRequestPml
extends ChEmedEprMedicationRequest {
    @Child(name="authorDocument")
    @Extension(url="http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-author", definedLocally=false)
    protected @Nullable Reference authorDocument;
    @Child(name="parentDocument")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-prescription")
    protected @Nullable ChEmedExtPrescription parentDocument;

    public ChEmedEprMedicationRequestPml() {
    }

    public ChEmedEprMedicationRequestPml(UUID entryUuid) {
        super(entryUuid);
    }

    @ExpectsValidResource
    public ChEmedEprPractitionerRole resolvePerformer() throws InvalidEmedContentException {
        if (!this.hasPerformer()) {
            throw new InvalidEmedContentException("The author and her/his organization of the medical decision are missing.");
        }
        IBaseResource resource = this.getPerformer().getResource();
        if (resource instanceof ChEmedEprPractitionerRole) {
            ChEmedEprPractitionerRole chEmedEprPractitionerRole = (ChEmedEprPractitionerRole)resource;
            return chEmedEprPractitionerRole;
        }
        throw new InvalidEmedContentException("The reference to the author and her/his organization of the medical decision isn't of the right type.");
    }

    public Reference getAuthorDocumentElement() {
        if (this.authorDocument == null) {
            this.authorDocument = new Reference();
        }
        return this.authorDocument;
    }

    @ExpectsValidResource
    public @Nullable DomainResource getAuthorDocument() throws InvalidEmedContentException {
        IBaseResource resource = this.getAuthorDocumentElement().getResource();
        if (resource == null) {
            return null;
        }
        if (resource instanceof ChCorePatientEpr || resource instanceof ChEmedEprPractitionerRole) {
            return (DomainResource)resource;
        }
        throw new InvalidEmedContentException("The last author of the original document is invalid");
    }

    public ChEmedEprMedicationRequestPml setAuthorDocument(IBaseResource author) {
        this.authorDocument = References.createReference((Resource)author);
        return this;
    }

    public ChEmedEprMedicationRequestPml setPerformer(ChEmedEprPractitionerRole practitionerRole) {
        this.setPerformer(References.createReference((Resource)practitionerRole));
        return this;
    }

    public boolean hasAuthorDocument() {
        return this.authorDocument != null && !this.authorDocument.isEmpty();
    }

    public ChEmedExtPrescription getParentDocumentElement() {
        if (this.parentDocument == null) {
            this.parentDocument = new ChEmedExtPrescription();
        }
        return this.parentDocument;
    }

    public ChEmedEprMedicationRequestPml setParentDocumentElement(ChEmedExtPrescription parentDocument) {
        this.parentDocument = parentDocument;
        return this;
    }

    public boolean hasParentDocument() {
        return this.parentDocument != null && !this.parentDocument.isEmpty();
    }

    public ChEmedEprMedicationRequestPml copy() {
        ChEmedEprMedicationRequestPml copy = new ChEmedEprMedicationRequestPml();
        this.copyValues(copy);
        return copy;
    }

    @Override
    public void copyValues(MedicationRequest dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprMedicationRequestPml) {
            ChEmedEprMedicationRequestPml als = (ChEmedEprMedicationRequestPml)dst;
            als.authorDocument = this.authorDocument == null ? null : this.authorDocument.copy();
            als.parentDocument = this.parentDocument == null ? null : this.parentDocument.copy();
        }
    }
}

