/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pml;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.UUID;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprMedicationStatementMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprMedicationStatementChanged;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprCompositionPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprMedicationDispensePml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprMedicationRequestPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprMedicationStatementPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pml.ChEmedEprObservationPml;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprMedicationRequestPre;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationlist")
public class ChEmedEprDocumentPml
extends ChEmedEprDocument {
    private static final long serialVersionUID = -1802412421572043644L;

    public ChEmedEprDocumentPml() {
    }

    public ChEmedEprDocumentPml(UUID documentId, Instant timestamp) {
        super(documentId, timestamp);
    }

    @Override
    public EmedDocumentType getEmedType() {
        return EmedDocumentType.PML;
    }

    public boolean hasCompositionEntry() {
        return this.getEntryByResourceType(ChEmedEprCompositionPml.class) != null;
    }

    @Override
    public Bundle.BundleEntryComponent getCompositionEntry() {
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionPml.class);
        if (entry == null) {
            entry = new Bundle.BundleEntryComponent();
            this.getEntry().add(0, entry);
        }
        return entry;
    }

    @Override
    @ExpectsValidResource
    public ChEmedEprCompositionPml resolveComposition() {
        Resource resource;
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionPml.class);
        if (entry != null && (resource = entry.getResource()) instanceof ChEmedEprCompositionPml) {
            ChEmedEprCompositionPml composition = (ChEmedEprCompositionPml)resource;
            return composition;
        }
        throw new InvalidEmedContentException("The ChEmedEprCompositionPml is missing in the document Bundle");
    }

    public Bundle.BundleEntryComponent setComposition(ChEmedEprCompositionPml composition) {
        return this.getCompositionEntry().setFullUrl(composition.getIdentifier().getValue()).setResource((Resource)composition);
    }

    public Bundle.BundleEntryComponent addMedicationStatement(ChEmedEprMedicationStatementPml medicationStatement) {
        return this.addEntry().setFullUrl(medicationStatement.getIdentifierFirstRep().getValue()).setResource((Resource)medicationStatement);
    }

    public Bundle.BundleEntryComponent addMedicationStatement(ChEmedEprMedicationStatementMtp medicationStatement) {
        return this.addEntry().setFullUrl(medicationStatement.getIdentifierFirstRep().getValue()).setResource((Resource)medicationStatement);
    }

    public Bundle.BundleEntryComponent addMedicationStatement(ChEmedEprMedicationStatementChanged medicationStatement) {
        return this.addEntry().setFullUrl(medicationStatement.getIdentifierFirstRep().getValue()).setResource((Resource)medicationStatement);
    }

    public Bundle.BundleEntryComponent addMedicationRequest(ChEmedEprMedicationRequestPml medicationRequest) {
        return this.addEntry().setFullUrl(medicationRequest.getIdentifierFirstRep().getValue()).setResource((Resource)medicationRequest);
    }

    public Bundle.BundleEntryComponent addMedicationRequest(ChEmedEprMedicationRequestPre medicationRequest) {
        return this.addEntry().setFullUrl(medicationRequest.getIdentifierFirstRep().getValue()).setResource((Resource)medicationRequest);
    }

    public Bundle.BundleEntryComponent addMedicationDispense(ChEmedEprMedicationDispensePml medicationDispense) {
        return this.addEntry().setFullUrl(medicationDispense.getIdentifierFirstRep().getValue()).setResource((Resource)medicationDispense);
    }

    public Bundle.BundleEntryComponent addObservation(ChEmedEprObservationPml observation) {
        return this.addEntry().setFullUrl(observation.getIdentifierFirstRep().getValue()).setResource((Resource)observation);
    }

    public ChEmedEprDocumentPml copy() {
        ChEmedEprDocumentPml copy = new ChEmedEprDocumentPml();
        this.copyValues(copy);
        return copy;
    }
}

