/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.pml;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseReference;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.enums.CompositionTitle;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprComposition;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprEntry;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-composition-medicationlist")
public class ChEmedEprCompositionPml
extends ChEmedEprComposition {
    public ChEmedEprCompositionPml() {
    }

    public ChEmedEprCompositionPml(UUID compositionId, Instant date, LanguageCode language) {
        super(compositionId, date, language);
        this.getType().addCoding(new Coding("http://snomed.info/sct", "721912009", "Medication summary document (record artifact)"));
        this.getType().addCoding(new Coding("http://loinc.org", "56445-0", "Medication summary Document"));
        this.setTitle(CompositionTitle.PML.getDisplayName(language));
    }

    @ExpectsValidResource
    public Device resolveAuthor() throws InvalidEmedContentException {
        if (!this.hasAuthor()) {
            throw new InvalidEmedContentException("The composition requires an author.");
        }
        IBaseResource iBaseResource = this.getAuthorFirstRep().getResource();
        if (iBaseResource instanceof Device) {
            Device device = (Device)iBaseResource;
            return device;
        }
        throw new InvalidEmedContentException("The author is not a device.");
    }

    public Composition.SectionComponent getListSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("10160-0");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "10160-0", "History of medication use"));
            section.setTitle("Medication List");
        }
        return section;
    }

    public Composition.SectionComponent getAnnotationSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("48767-8");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "48767-8", "Annotation comment"));
            section.setTitle("Comment");
        }
        return section;
    }

    @ExpectsValidResource
    public List<DomainResource> getResources() {
        Composition.SectionComponent section = this.getListSection();
        return section.getEntry().stream().map(BaseReference::getResource).filter(DomainResource.class::isInstance).map(DomainResource.class::cast).toList();
    }

    @ExpectsValidResource
    public List<ChEmedEprEntry> resolveEntries() {
        return this.getListSection().getEntry().stream().map(BaseReference::getResource).filter(ChEmedEprEntry.class::isInstance).map(ChEmedEprEntry.class::cast).toList();
    }

    public boolean hasListSection() {
        return this.getSectionByLoincCode("10160-0") != null;
    }

    public ChEmedEprCompositionPml addAuthor(Device author) {
        this.addAuthor(References.createReference((Resource)author));
        return this;
    }

    public ChEmedEprCompositionPml copy() {
        ChEmedEprCompositionPml copy = new ChEmedEprCompositionPml();
        this.copyValues(copy);
        return copy;
    }
}

