/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.padv;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.UUID;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprMedicationStatementMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprCompositionPadv;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprObservationPadv;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-pharmaceuticaladvice")
public class ChEmedEprDocumentPadv
extends ChEmedEprDocument {
    private static final long serialVersionUID = -4904031873679621597L;

    public ChEmedEprDocumentPadv() {
    }

    public ChEmedEprDocumentPadv(UUID documentId, Instant timestamp) {
        super(documentId, timestamp);
    }

    @Override
    public EmedDocumentType getEmedType() {
        return EmedDocumentType.PADV;
    }

    public boolean hasCompositionEntry() {
        return this.getEntryByResourceType(ChEmedEprCompositionPadv.class) != null;
    }

    @Override
    public Bundle.BundleEntryComponent getCompositionEntry() {
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionPadv.class);
        if (entry == null) {
            entry = new Bundle.BundleEntryComponent();
            this.getEntry().add(0, entry);
        }
        return entry;
    }

    @Override
    @ExpectsValidResource
    public ChEmedEprCompositionPadv resolveComposition() {
        Resource resource;
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionPadv.class);
        if (entry != null && (resource = entry.getResource()) instanceof ChEmedEprCompositionPadv) {
            ChEmedEprCompositionPadv composition = (ChEmedEprCompositionPadv)resource;
            return composition;
        }
        throw new InvalidEmedContentException("The ChEmedEprCompositionPadv is missing in the document Bundle");
    }

    public ChEmedEprDocumentPadv setComposition(ChEmedEprCompositionPadv composition) {
        this.getCompositionEntry().setFullUrl("urn:uuid:" + composition.resolveIdentifier()).setResource((Resource)composition);
        return this;
    }

    public ChEmedEprDocumentPadv addObservation(ChEmedEprObservationPadv observation) {
        this.addEntry().setFullUrl("urn:uuid:" + observation.resolveIdentifier()).setResource((Resource)observation);
        return this;
    }

    public ChEmedEprDocumentPadv addMedicationStatement(ChEmedEprMedicationStatementMtp observation) {
        this.addEntry().setFullUrl("urn:uuid:" + observation.resolveIdentifier()).setResource((Resource)observation);
        return this;
    }

    public ChEmedEprDocumentPadv copy() {
        ChEmedEprDocumentPadv copy = new ChEmedEprDocumentPadv();
        this.copyValues(copy);
        return copy;
    }
}

