/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.padv;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.enums.CompositionTitle;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprComposition;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprObservationPadv;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-composition-pharmaceuticaladvice")
public class ChEmedEprCompositionPadv
extends ChEmedEprComposition {
    public ChEmedEprCompositionPadv() {
    }

    public ChEmedEprCompositionPadv(UUID compositionId, Instant date, LanguageCode language) {
        super(compositionId, date, language);
        this.getType().addCoding(new Coding("http://snomed.info/sct", "419891008", "Record artifact (record artifact)"));
        this.getType().addCoding(new Coding("http://loinc.org", "61356-2", "Medication pharmaceutical advice.extended Document"));
        this.setTitle(CompositionTitle.PADV.getDisplayName(language));
    }

    @ExpectsValidResource
    public List<DomainResource> resolveAuthors() throws InvalidEmedContentException {
        if (!this.hasAuthor()) {
            throw new InvalidEmedContentException("The composition requires at least one author.");
        }
        ArrayList<DomainResource> authors = new ArrayList<DomainResource>();
        for (Reference reference : this.getAuthor()) {
            IBaseResource resource = reference.getResource();
            if (resource instanceof ChEmedEprPractitionerRole || resource instanceof ChCorePatientEpr || resource instanceof Device) {
                authors.add((DomainResource)resource);
                continue;
            }
            throw new InvalidEmedContentException("An author is invalid.");
        }
        return authors;
    }

    @ExpectsValidResource
    public Resource resolveMainHumanAuthor() {
        return (Resource)this.resolveAuthors().stream().filter(author -> author instanceof ChEmedEprPractitionerRole || author instanceof ChCorePatientEpr).findFirst().orElseThrow(() -> new InvalidEmedContentException(""));
    }

    public Composition.SectionComponent getPharmaceuticalAdviceSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("61357-0");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "61357-0", "Medication pharmaceutical advice.brief"));
        }
        return section;
    }

    @ExpectsValidResource
    public ChEmedEprObservationPadv resolveObservation() throws InvalidEmedContentException {
        Composition.SectionComponent section = this.getPharmaceuticalAdviceSection();
        if (!section.hasEntry()) {
            throw new InvalidEmedContentException("The section has no entries");
        }
        IBaseResource resource = ((Reference)section.getEntry().get(0)).getResource();
        if (resource instanceof ChEmedEprObservationPadv) {
            ChEmedEprObservationPadv medicationPharmaceuticalAdvice = (ChEmedEprObservationPadv)resource;
            return medicationPharmaceuticalAdvice;
        }
        throw new InvalidEmedContentException("The section isn't referencing a ChEmedEprObservationPadv resource");
    }

    public Composition.SectionComponent getAnnotationSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("48767-8");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "48767-8", "Annotation comment"));
        }
        return section;
    }

    public boolean hasPharmaceuticalAdviceSection() {
        return this.getSectionByLoincCode("61357-0") != null;
    }

    public boolean hasAnnotationSection() {
        return this.getSectionByLoincCode("48767-8") != null;
    }

    public ChEmedEprCompositionPadv addAuthor(ChEmedEprPractitionerRole author) {
        this.addAuthor(References.createReference((Resource)author));
        return this;
    }

    public ChEmedEprCompositionPadv addAuthor(ChCorePatientEpr author) {
        this.addAuthor(References.createReference((Resource)author));
        return this;
    }

    public ChEmedEprCompositionPadv copy() {
        ChEmedEprCompositionPadv copy = new ChEmedEprCompositionPadv();
        this.copyValues(copy);
        return copy;
    }
}

