/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.mtp;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.UUID;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprCompositionMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprMedicationStatementMtp;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationtreatmentplan")
public class ChEmedEprDocumentMtp
extends ChEmedEprDocument {
    private static final long serialVersionUID = 1095863629301164639L;

    public ChEmedEprDocumentMtp() {
    }

    public ChEmedEprDocumentMtp(UUID documentId, Instant timestamp) {
        super(documentId, timestamp);
    }

    @Override
    public EmedDocumentType getEmedType() {
        return EmedDocumentType.MTP;
    }

    public boolean hasCompositionEntry() {
        return this.getEntryByResourceType(ChEmedEprCompositionMtp.class) != null;
    }

    @Override
    public Bundle.BundleEntryComponent getCompositionEntry() {
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionMtp.class);
        if (entry == null) {
            entry = new Bundle.BundleEntryComponent();
            this.getEntry().add(0, entry);
        }
        return entry;
    }

    @Override
    @ExpectsValidResource
    public ChEmedEprCompositionMtp resolveComposition() {
        Resource resource;
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionMtp.class);
        if (entry != null && (resource = entry.getResource()) instanceof ChEmedEprCompositionMtp) {
            ChEmedEprCompositionMtp composition = (ChEmedEprCompositionMtp)resource;
            return composition;
        }
        throw new InvalidEmedContentException("The ChEmedEprCompositionMtp is missing in the document Bundle");
    }

    public ChEmedEprDocumentMtp setComposition(ChEmedEprCompositionMtp composition) {
        this.getCompositionEntry().setFullUrl(composition.getIdentifier().getValue()).setResource((Resource)composition);
        return this;
    }

    public ChEmedEprDocumentMtp setMedicationStatement(ChEmedEprMedicationStatementMtp medicationStatement) {
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprMedicationStatementMtp.class);
        if (entry == null) {
            entry = this.addEntry();
        }
        entry.setFullUrl(medicationStatement.getIdentifierFirstRep().getValue());
        entry.setResource((Resource)medicationStatement);
        return this;
    }

    public ChEmedEprDocumentMtp copy() {
        ChEmedEprDocumentMtp copy = new ChEmedEprDocumentMtp();
        this.copyValues(copy);
        return copy;
    }
}

