/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.extension;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import java.util.Date;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.Reference;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;

@Block
public class ChExtEprDataEnterer
extends BackboneElement {
    @Child(name="enterer", min=1)
    @Extension(url="enterer", definedLocally=false)
    protected @Nullable Reference enterer;
    @Child(name="timestamp")
    @Extension(url="http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-epr-time", definedLocally=false)
    protected @Nullable DateType timestamp;

    @ExpectsValidResource
    public ChEmedEprPractitionerRole resolveEnterer() throws InvalidEmedContentException {
        if (!this.hasEnterer()) {
            throw new InvalidEmedContentException("Information about the person and organization that entered data is missing.");
        }
        IBaseResource resource = this.enterer.getResource();
        if (resource instanceof ChEmedEprPractitionerRole) {
            ChEmedEprPractitionerRole chPractitionerRole = (ChEmedEprPractitionerRole)resource;
            return chPractitionerRole;
        }
        throw new InvalidEmedContentException("The resource isn't of a ChEmedEprPractitionerRole type.");
    }

    public @Nullable Date getTimestamp() {
        if (!this.hasTimestamp()) {
            return null;
        }
        return (Date)this.timestamp.getValue();
    }

    public ChExtEprDataEnterer setEnterer(ChEmedEprPractitionerRole practitionerRole) {
        if (this.enterer == null) {
            this.enterer = new Reference();
        }
        this.enterer.setResource((IBaseResource)practitionerRole);
        return this;
    }

    public ChExtEprDataEnterer setTimestamp(Date timestamp) {
        if (this.timestamp == null) {
            this.timestamp = new DateType();
        }
        this.timestamp.setValue(timestamp);
        return this;
    }

    public boolean hasEnterer() {
        return this.enterer != null && this.enterer.getResource() != null;
    }

    public boolean hasTimestamp() {
        return this.timestamp != null && this.timestamp.hasValue();
    }

    public ChExtEprDataEnterer copy() {
        ChExtEprDataEnterer copy = new ChExtEprDataEnterer();
        this.copyValues(copy);
        return copy;
    }

    public void copyValues(BackboneElement dst) {
        super.copyValues(dst);
        if (dst instanceof ChExtEprDataEnterer) {
            ChExtEprDataEnterer als = (ChExtEprDataEnterer)dst;
            als.enterer = this.enterer == null ? null : this.enterer.copy();
            als.timestamp = this.timestamp == null ? null : this.timestamp.copy();
        }
    }
}

