/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.extension;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import ca.uhn.fhir.util.ElementUtil;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.BackboneElement;
import org.hl7.fhir.r4.model.Identifier;
import org.projecthusky.common.utils.datatypes.Uuids;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedEntryType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.model.common.EmedReference;

@Block
public abstract class ChEmedExtensionReference
extends BackboneElement {
    @Child(name="extension:id", min=1)
    @Extension(url="id", definedLocally=false)
    protected @Nullable Identifier extensionId;
    @Child(name="extension:externalDocumentId", min=1)
    @Extension(url="externalDocumentId", definedLocally=false)
    protected @Nullable Identifier externalDocumentId;

    public ChEmedExtensionReference() {
    }

    public ChEmedExtensionReference(UUID id, UUID externalDocumentId) {
        this.setExtensionId(id);
        this.setExternalDocumentId(externalDocumentId);
    }

    @ExpectsValidResource
    public UUID resolveIdentifier() throws InvalidEmedContentException {
        if (!this.hasExtensionId()) {
            throw new InvalidEmedContentException("The ID of the document is missing.");
        }
        return Uuids.parseUrnEncoded((String)this.extensionId.getValue());
    }

    @ExpectsValidResource
    public UUID resolveExternalDocumentId() throws InvalidEmedContentException {
        if (!this.hasExternalDocumentId()) {
            throw new InvalidEmedContentException("The ID of the external document is missing.");
        }
        return Uuids.parseUrnEncoded((String)this.externalDocumentId.getValue());
    }

    @ExpectsValidResource
    public EmedReference resolveReference() throws InvalidEmedContentException {
        return new EmedReference(this.resolveExternalDocumentId(), this.resolveIdentifier(), null, this.getEntryType());
    }

    public Identifier getExtensionIdElement() {
        if (this.extensionId == null) {
            this.extensionId = new Identifier();
        }
        return this.extensionId;
    }

    public Identifier getExternalDocumentIdElement() {
        if (this.externalDocumentId == null) {
            this.externalDocumentId = new Identifier();
        }
        return this.externalDocumentId;
    }

    public ChEmedExtensionReference setExtensionId(UUID extensionId) {
        if (this.extensionId == null) {
            this.extensionId = new Identifier();
        }
        this.extensionId.setSystem("urn:ietf:rfc:3986").setValue("urn:uuid:" + extensionId);
        return this;
    }

    public ChEmedExtensionReference setExternalDocumentId(UUID externalDocumentId) {
        if (this.externalDocumentId == null) {
            this.externalDocumentId = new Identifier();
        }
        this.externalDocumentId.setSystem("urn:ietf:rfc:3986").setValue("urn:uuid:" + externalDocumentId);
        return this;
    }

    public boolean hasExtensionId() {
        return this.extensionId != null && !this.extensionId.isEmpty();
    }

    public boolean hasExternalDocumentId() {
        return this.externalDocumentId != null && !this.externalDocumentId.isEmpty();
    }

    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.extensionId, this.externalDocumentId});
    }

    public abstract EmedEntryType getEntryType();

    public void copyValues(BackboneElement dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedExtensionReference) {
            ChEmedExtensionReference als = (ChEmedExtensionReference)dst;
            als.extensionId = this.extensionId == null ? null : this.extensionId.copy();
            als.externalDocumentId = this.externalDocumentId == null ? null : this.externalDocumentId.copy();
        }
    }
}

