/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.dis;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Ratio;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChEmedOrganization;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedRatioWithEmedUnits;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprMedication;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-medication-medicationdispense")
public class ChEmedEprMedicationDis
extends ChEmedEprMedication {
    @ExpectsValidResource
    public ChEmedOrganization resolveManufacturer() throws InvalidEmedContentException {
        if (!this.hasManufacturer()) {
            throw new InvalidEmedContentException("The manufacturer is not specified");
        }
        IBaseResource resource = this.getManufacturer().getResource();
        if (resource instanceof ChEmedOrganization) {
            ChEmedOrganization chManufacturer = (ChEmedOrganization)resource;
            return chManufacturer;
        }
        throw new InvalidEmedContentException("The manufacturer is invalid");
    }

    @ExpectsValidResource
    public ChEmedRatioWithEmedUnits resolveAmount() throws InvalidEmedContentException {
        if (!this.hasAmount()) {
            throw new InvalidEmedContentException("The package size is missing.");
        }
        Ratio ratio = this.getAmount();
        if (ratio instanceof ChEmedRatioWithEmedUnits) {
            ChEmedRatioWithEmedUnits chRatio = (ChEmedRatioWithEmedUnits)ratio;
            return chRatio;
        }
        throw new InvalidEmedContentException("The package size isn't of the right type.");
    }

    public ChEmedEprMedicationDis setAmount(ChEmedRatioWithEmedUnits amount) {
        super.setAmount((Ratio)amount);
        return this;
    }

    @Override
    public ChEmedEprMedicationDis copy() {
        ChEmedEprMedicationDis copy = new ChEmedEprMedicationDis();
        this.copyValues(copy);
        return copy;
    }
}

