/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.dis;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.UUID;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDocument;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprCompositionDis;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprMedicationDispenseDis;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-document-medicationdispense")
public class ChEmedEprDocumentDis
extends ChEmedEprDocument {
    private static final long serialVersionUID = 7824141700654582502L;

    public ChEmedEprDocumentDis() {
    }

    public ChEmedEprDocumentDis(UUID documentId, Instant timestamp) {
        super(documentId, timestamp);
    }

    @Override
    public EmedDocumentType getEmedType() {
        return EmedDocumentType.DIS;
    }

    public boolean hasCompositionEntry() {
        return this.getEntryByResourceType(ChEmedEprCompositionDis.class) != null;
    }

    @Override
    public Bundle.BundleEntryComponent getCompositionEntry() {
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionDis.class);
        if (entry == null) {
            entry = new Bundle.BundleEntryComponent();
            this.getEntry().add(0, entry);
        }
        return entry;
    }

    @Override
    @ExpectsValidResource
    public ChEmedEprCompositionDis resolveComposition() {
        Resource resource;
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChEmedEprCompositionDis.class);
        if (entry != null && (resource = entry.getResource()) instanceof ChEmedEprCompositionDis) {
            ChEmedEprCompositionDis composition = (ChEmedEprCompositionDis)resource;
            return composition;
        }
        throw new InvalidEmedContentException("The ChEmedEprCompositionDis is missing in the document Bundle");
    }

    public ChEmedEprDocumentDis addMedicationDispense(ChEmedEprMedicationDispenseDis medicationDispense) {
        this.addEntry().setFullUrl(medicationDispense.getIdentifierFirstRep().getValue()).setResource((Resource)medicationDispense);
        return this;
    }

    public ChEmedEprDocumentDis setComposition(ChEmedEprCompositionDis composition) {
        this.getCompositionEntry().setFullUrl(composition.getIdentifier().getValue()).setResource((Resource)composition);
        return this;
    }

    public ChEmedEprDocumentDis copy() {
        ChEmedEprDocumentDis copy = new ChEmedEprDocumentDis();
        this.copyValues(copy);
        return copy;
    }
}

