/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource.dis;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Device;
import org.hl7.fhir.r4.model.DomainResource;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.enums.CompositionTitle;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprComposition;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprMedicationDispenseDis;
import org.projecthusky.fhir.emed.ch.epr.util.References;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-composition-medicationdispense")
public class ChEmedEprCompositionDis
extends ChEmedEprComposition {
    public ChEmedEprCompositionDis() {
    }

    public ChEmedEprCompositionDis(UUID compositionId, Instant date, LanguageCode language) {
        super(compositionId, date, language);
        this.getType().addCoding(new Coding("http://snomed.info/sct", "294121000195110", "Medication dispense document (record artifact)"));
        this.getType().addCoding(new Coding("http://loinc.org", "60593-1", "Medication dispensed.extended Document"));
        this.setTitle(CompositionTitle.DIS.getDisplayName(language));
    }

    public Composition.SectionComponent getDispenseSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("60590-7");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "60590-7", "Medication dispensed.brief"));
        }
        return section;
    }

    @ExpectsValidResource
    public ChEmedEprMedicationDispenseDis resolveMedicationDispense() throws InvalidEmedContentException {
        Composition.SectionComponent section = this.getDispenseSection();
        if (!section.hasEntry()) {
            throw new InvalidEmedContentException("The section has no entries");
        }
        IBaseResource resource = ((Reference)section.getEntry().get(0)).getResource();
        if (resource instanceof ChEmedEprMedicationDispenseDis) {
            ChEmedEprMedicationDispenseDis medicationDispense = (ChEmedEprMedicationDispenseDis)resource;
            return medicationDispense;
        }
        throw new InvalidEmedContentException("The section isn't referencing a ChEmedEprMedicationDispenseDis resource");
    }

    @ExpectsValidResource
    public List<DomainResource> resolveAuthors() throws InvalidEmedContentException {
        if (!this.hasAuthor()) {
            throw new InvalidEmedContentException("The composition requires at least one author.");
        }
        ArrayList<DomainResource> authors = new ArrayList<DomainResource>();
        for (Reference reference : this.getAuthor()) {
            IBaseResource resource = reference.getResource();
            if (resource instanceof ChEmedEprPractitionerRole || resource instanceof ChCorePatientEpr || resource instanceof Device) {
                authors.add((DomainResource)resource);
                continue;
            }
            throw new InvalidEmedContentException("An author is invalid.");
        }
        return authors;
    }

    @ExpectsValidResource
    public Resource resolveMainHumanAuthor() {
        return (Resource)this.resolveAuthors().stream().filter(author -> author instanceof ChEmedEprPractitionerRole || author instanceof ChCorePatientEpr).findFirst().orElseThrow(() -> new InvalidEmedContentException(""));
    }

    public Composition.SectionComponent getAnnotationSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode("48767-8");
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", "48767-8", "Annotation comment"));
        }
        return section;
    }

    public boolean hasDispenseSection() {
        return this.getSectionByLoincCode("60590-7") != null;
    }

    public boolean hasAnnotationSection() {
        return this.getSectionByLoincCode("48767-8") != null;
    }

    public ChEmedEprCompositionDis addAuthor(ChEmedEprPractitionerRole author) {
        this.addAuthor(References.createReference((Resource)author));
        return this;
    }

    public ChEmedEprCompositionDis addAuthor(ChCorePatientEpr author) {
        this.addAuthor(References.createReference((Resource)author));
        return this;
    }

    public ChEmedEprCompositionDis setMedicationDispense(ChEmedEprMedicationDispenseDis medicationDispense) {
        List entry = this.getDispenseSection().getEntry();
        Reference reference = References.createReference((Resource)medicationDispense);
        if (entry.isEmpty()) {
            entry.add(reference);
        } else {
            entry.set(0, reference);
        }
        return this;
    }

    public ChEmedEprCompositionDis copy() {
        ChEmedEprCompositionDis copy = new ChEmedEprCompositionDis();
        this.copyValues(copy);
        return copy;
    }
}

