/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChEmedOrganization;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitioner;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-practitionerrole")
public class ChEmedEprPractitionerRole
extends PractitionerRole {
    @ExpectsValidResource
    public ChEmedEprPractitioner resolvePractitioner() {
        if (this.practitioner == null || this.practitioner.isEmpty()) {
            throw new InvalidEmedContentException("The practitioner is missing");
        }
        IBaseResource resource = this.practitioner.getResource();
        if (resource instanceof ChEmedEprPractitioner) {
            ChEmedEprPractitioner thisPractitioner = (ChEmedEprPractitioner)resource;
            return thisPractitioner;
        }
        throw new InvalidEmedContentException("The practitioner is invalid");
    }

    @ExpectsValidResource
    public ChEmedOrganization resolveOrganization() throws InvalidEmedContentException {
        if (!this.hasOrganization()) {
            throw new InvalidEmedContentException("The organization is not specified");
        }
        IBaseResource resource = this.getOrganization().getResource();
        if (resource instanceof ChEmedOrganization) {
            ChEmedOrganization chOrganization = (ChEmedOrganization)resource;
            return chOrganization;
        }
        throw new InvalidEmedContentException("The organization is not specified");
    }

    public ChEmedEprPractitionerRole copy() {
        ChEmedEprPractitionerRole copy = new ChEmedEprPractitionerRole();
        this.copyValues(copy);
        return copy;
    }
}

