/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.List;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Practitioner;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.util.Identifiers;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-practitioner")
public class ChEmedEprPractitioner
extends Practitioner {
    @ExpectsValidResource
    public String resolveGln() {
        Identifier identifier = Identifiers.getBySystem((List)this.getIdentifier(), (String)"urn:oid:2.51.1.3");
        if (identifier == null || identifier.getValue() == null) {
            throw new InvalidEmedContentException("The GLN is missing");
        }
        return identifier.getValue();
    }

    public Identifier setGln(String gln) {
        Identifier identifier = Identifiers.getBySystem((List)this.getIdentifier(), (String)"urn:oid:2.51.1.3");
        if (identifier == null) {
            identifier = new Identifier();
            identifier.setSystem("urn:oid:2.51.1.3");
        }
        identifier.setValue(gln);
        return identifier;
    }

    public List<String> resolveZsr() {
        return Identifiers.findBySystem((List)this.getIdentifier(), (String)"urn:oid:2.16.756.5.30.1.123.100.2.1.1").stream().map(Identifier::getValue).toList();
    }

    public Identifier addZsr(String zsr) {
        Identifier identifier = this.addIdentifier();
        identifier.setSystem("urn:oid:2.16.756.5.30.1.123.100.2.1.1");
        identifier.setValue(zsr);
        return identifier;
    }

    @ExpectsValidResource
    public HumanName resolveName() {
        if (!this.name.isEmpty()) {
            return (HumanName)this.name.get(0);
        }
        throw new InvalidEmedContentException("The human name is missing");
    }

    @ExpectsValidResource
    public Address resolveAddress() {
        if (!this.address.isEmpty()) {
            return (Address)this.address.get(0);
        }
        throw new InvalidEmedContentException("The address is missing");
    }

    public ChEmedEprPractitioner setName(HumanName humanName) {
        if (this.hasName()) {
            this.getName().set(0, humanName);
        } else {
            this.addName(humanName);
        }
        return this;
    }

    public ChEmedEprPractitioner setAddress(Address address) {
        if (this.hasAddress()) {
            this.getAddress().set(0, address);
        } else {
            this.addAddress(address);
        }
        return this;
    }

    public ChEmedEprPractitioner copy() {
        ChEmedEprPractitioner copy = new ChEmedEprPractitioner();
        this.copyValues(copy);
        return copy;
    }
}

