/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import java.time.LocalDate;
import java.util.Date;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Observation;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;

public class ChEmedEprObservationBodyWeight
extends Observation {
    public ChEmedEprObservationBodyWeight() {
        this.getValueQuantity().setUnit("kg").setCode("kg").setSystem("http://unitsofmeasure.org");
        this.getCode().getCodingFirstRep().setCode("29463-7").setSystem("http://loinc.org");
    }

    public ChEmedEprObservationBodyWeight(String weightValue, LocalDate weightDate) {
        this();
        this.getValueQuantity().getValueElement().setValueAsString(weightValue);
        this.getEffectiveDateTimeType().setValue((Date)java.sql.Date.valueOf(weightDate));
    }

    @ExpectsValidResource
    public ChCorePatientEpr resolveSubject() {
        IBaseResource iBaseResource;
        if (this.hasSubject() && (iBaseResource = this.getSubject().getResource()) instanceof ChCorePatientEpr) {
            ChCorePatientEpr patient = (ChCorePatientEpr)iBaseResource;
            return patient;
        }
        throw new InvalidEmedContentException("The subject (Patient) is missing");
    }
}

