/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.common.utils.datatypes.Uuids;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedEntryType;
import org.projecthusky.fhir.emed.ch.common.enums.EmedPadvEntryType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.model.common.EmedReference;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprEntry;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtDispense;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtPrescription;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtTreatmentPlan;
import org.projecthusky.fhir.emed.ch.epr.resource.mtp.ChEmedEprMedicationStatementMtp;
import org.projecthusky.fhir.emed.ch.epr.resource.padv.ChEmedEprMedicationStatementChanged;
import org.projecthusky.fhir.emed.ch.epr.resource.pre.ChEmedEprMedicationRequestPre;
import org.projecthusky.fhir.emed.ch.epr.util.References;

public abstract class ChEmedEprObservation
extends Observation
implements ChEmedEprEntry {
    @Child(name="treatmentPlan")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-treatmentplan", definedLocally=false)
    protected @Nullable ChEmedExtTreatmentPlan treatmentPlan;
    @Child(name="prescription")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-prescription", definedLocally=false)
    protected @Nullable ChEmedExtPrescription prescription;
    @Child(name="dispense")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-dispense", definedLocally=false)
    protected @Nullable ChEmedExtDispense dispense;
    @Child(name="medicationStatementChanged")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-medicationstatement-changed", definedLocally=false)
    protected @Nullable Reference medicationStatementChanged;
    @Child(name="medicationRequestChanged")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-medicationrequest-changed", definedLocally=false)
    protected @Nullable Reference medicationRequestChanged;

    public ChEmedEprObservation() {
    }

    public ChEmedEprObservation(UUID entryUuid, EmedPadvEntryType padvType) {
        this.setStatus(Observation.ObservationStatus.FINAL);
        this.addIdentifier().setValue("urn:uuid:" + entryUuid).setSystem("urn:ietf:rfc:3986");
        this.setCode(padvType.getCodeableConcept());
    }

    @Override
    public EmedEntryType getEmedType() {
        return EmedEntryType.PADV;
    }

    @Override
    @ExpectsValidResource
    public UUID resolveIdentifier() throws InvalidEmedContentException {
        if (!this.hasIdentifier()) {
            throw new InvalidEmedContentException("The ID is missing.");
        }
        return Uuids.parseUrnEncoded((String)this.getIdentifierFirstRep().getValue());
    }

    @ExpectsValidResource
    public @Nullable ChEmedEprMedicationStatementChanged resolveMedicationStatementChanged() throws InvalidEmedContentException {
        if (!this.hasMedicationStatementChanged()) {
            return null;
        }
        IBaseResource resource = this.getMedicationStatementChangedReference().getResource();
        if (resource instanceof ChEmedEprMedicationStatementChanged) {
            ChEmedEprMedicationStatementChanged chEmedEprMedicationStatementChanged = (ChEmedEprMedicationStatementChanged)resource;
            return chEmedEprMedicationStatementChanged;
        }
        throw new InvalidEmedContentException("The medication statement resource isn't of the right type.");
    }

    @ExpectsValidResource
    public @Nullable ChEmedEprMedicationRequestPre resolveMedicationRequestChanged() throws InvalidEmedContentException {
        if (!this.hasMedicationRequestChanged()) {
            return null;
        }
        IBaseResource resource = this.getMedicationRequestChangedReference().getResource();
        if (resource instanceof ChEmedEprMedicationRequestPre) {
            ChEmedEprMedicationRequestPre chEmedEprMedicationRequestPre = (ChEmedEprMedicationRequestPre)resource;
            return chEmedEprMedicationRequestPre;
        }
        throw new InvalidEmedContentException("The medication request resource isn't of the right type.");
    }

    @ExpectsValidResource
    public EmedPadvEntryType resolvePadvEntryType() throws InvalidEmedContentException {
        if (!this.hasCode()) {
            throw new InvalidEmedContentException("The PADV entry type is missing.");
        }
        EmedPadvEntryType emedPadvEntryType = EmedPadvEntryType.getEnum((Coding)this.getCode().getCodingFirstRep());
        if (emedPadvEntryType != null) {
            return emedPadvEntryType;
        }
        throw new InvalidEmedContentException("The PADV entry type is invalid.");
    }

    @ExpectsValidResource
    public Instant resolveIssued() throws InvalidEmedContentException {
        if (!this.hasIssued()) {
            throw new InvalidEmedContentException("The date/time this version was made available is missing.");
        }
        return this.getIssued().toInstant();
    }

    @ExpectsValidResource
    public String resolveNote() throws InvalidEmedContentException {
        if (!this.hasNote()) {
            throw new InvalidEmedContentException("The note is missing.");
        }
        return this.getNoteFirstRep().getText();
    }

    @ExpectsValidResource
    public @Nullable EmedReference resolveMtpReference() throws InvalidEmedContentException {
        if (!this.hasTreatmentPlan()) {
            return null;
        }
        return this.getTreatmentPlanElement().resolveReference();
    }

    @ExpectsValidResource
    public @Nullable EmedReference resolvePreReference() throws InvalidEmedContentException {
        if (!this.hasPrescription()) {
            return null;
        }
        return this.getPrescriptionElement().resolveReference();
    }

    @ExpectsValidResource
    public @Nullable EmedReference resolveDisReference() throws InvalidEmedContentException {
        if (!this.hasDispense()) {
            return null;
        }
        return this.getDispenseElement().resolveReference();
    }

    @ExpectsValidResource
    public EmedReference resolveReference() throws InvalidEmedContentException {
        EmedReference mtpReference = this.resolveMtpReference();
        EmedReference preReference = this.resolvePreReference();
        EmedReference disReference = this.resolveDisReference();
        List<EmedReference> nonnullReferences = Stream.of(mtpReference, preReference, disReference).filter(Objects::nonNull).toList();
        if (nonnullReferences.size() != 1) {
            throw new InvalidEmedContentException("A PADV Observation must have a single entry reference");
        }
        return nonnullReferences.get(0);
    }

    public ChEmedExtTreatmentPlan getTreatmentPlanElement() {
        if (this.treatmentPlan == null) {
            this.treatmentPlan = new ChEmedExtTreatmentPlan();
        }
        return this.treatmentPlan;
    }

    public ChEmedExtPrescription getPrescriptionElement() {
        if (this.prescription == null) {
            this.prescription = new ChEmedExtPrescription();
        }
        return this.prescription;
    }

    public ChEmedExtDispense getDispenseElement() {
        if (this.dispense == null) {
            this.dispense = new ChEmedExtDispense();
        }
        return this.dispense;
    }

    public Reference getMedicationStatementChangedReference() {
        if (this.medicationStatementChanged == null) {
            this.medicationStatementChanged = new Reference();
        }
        return this.medicationStatementChanged;
    }

    public Reference getMedicationRequestChangedReference() {
        if (this.medicationRequestChanged == null) {
            this.medicationRequestChanged = new Reference();
        }
        return this.medicationRequestChanged;
    }

    public ChEmedEprObservation setTreatmentPlanElement(ChEmedExtTreatmentPlan treatmentPlan) {
        this.treatmentPlan = treatmentPlan;
        return this;
    }

    public ChEmedEprObservation setPrescriptionElement(ChEmedExtPrescription prescription) {
        this.prescription = prescription;
        return this;
    }

    public ChEmedEprObservation setDispenseElement(ChEmedExtDispense dispense) {
        this.dispense = dispense;
        return this;
    }

    public ChEmedEprObservation setMedicationStatementChanged(ChEmedEprMedicationStatementMtp medicationStatement) {
        this.medicationStatementChanged = References.createReference((Resource)medicationStatement);
        return this;
    }

    public ChEmedEprObservation setMedicationRequestChanged(ChEmedEprMedicationRequestPre medicationRequest) {
        this.medicationRequestChanged = References.createReference((Resource)medicationRequest);
        return this;
    }

    public ChEmedEprObservation setPadvEntryType(EmedPadvEntryType padvEntryType) {
        this.setCode(padvEntryType.getCodeableConcept());
        return this;
    }

    public ChEmedEprObservation setIssued(Instant issued) {
        this.setIssued(Date.from(issued));
        return this;
    }

    public ChEmedEprObservation setNote(String note) {
        this.getNoteFirstRep().setText(note);
        return this;
    }

    public boolean hasTreatmentPlan() {
        return this.treatmentPlan != null && !this.treatmentPlan.isEmpty();
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public boolean hasDispense() {
        return this.dispense != null && !this.dispense.isEmpty();
    }

    public boolean hasMedicationStatementChanged() {
        return this.medicationStatementChanged != null && !this.medicationStatementChanged.isEmpty();
    }

    public boolean hasMedicationRequestChanged() {
        return this.medicationRequestChanged != null && !this.medicationRequestChanged.isEmpty();
    }

    public boolean hasPadvEntryType() {
        return this.hasCode();
    }

    @ExpectsValidResource
    public ChCorePatientEpr resolveSubject() {
        IBaseResource iBaseResource;
        if (this.hasSubject() && (iBaseResource = this.getSubject().getResource()) instanceof ChCorePatientEpr) {
            ChCorePatientEpr patient = (ChCorePatientEpr)iBaseResource;
            return patient;
        }
        throw new InvalidEmedContentException("The subject (Patient) is missing");
    }

    public void copyValues(Observation dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprObservation) {
            ChEmedEprObservation obs = (ChEmedEprObservation)dst;
            obs.treatmentPlan = this.treatmentPlan == null ? null : this.treatmentPlan.copy();
            obs.prescription = this.prescription == null ? null : this.prescription.copy();
            obs.dispense = this.dispense == null ? null : this.dispense.copy();
            obs.medicationStatementChanged = this.medicationStatementChanged == null ? null : this.medicationStatementChanged.copy();
            obs.medicationRequestChanged = this.medicationRequestChanged == null ? null : this.medicationRequestChanged.copy();
        }
    }
}

