/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.Type;
import org.projecthusky.common.utils.datatypes.Uuids;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedEntryType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedEprDosage;
import org.projecthusky.fhir.emed.ch.epr.enums.SubstanceAdministrationSubstitutionCode;
import org.projecthusky.fhir.emed.ch.epr.model.common.Author;
import org.projecthusky.fhir.emed.ch.epr.model.common.EffectiveDosageInstructions;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprEntry;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprMedication;

public abstract class ChEmedEprMedicationStatement
extends MedicationStatement
implements ChEmedEprEntry {
    @Child(name="substitution")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-substitution", definedLocally=false)
    protected @Nullable CodeableConcept substitution;

    protected ChEmedEprMedicationStatement() {
    }

    protected ChEmedEprMedicationStatement(UUID entryUuid) {
        this.setStatus(MedicationStatement.MedicationStatementStatus.COMPLETED);
        this.addIdentifier().setValue("urn:uuid:" + entryUuid).setSystem("urn:ietf:rfc:3986");
    }

    @Override
    public EmedEntryType getEmedType() {
        return EmedEntryType.MTP;
    }

    public CodeableConcept getSubstitution() {
        if (this.substitution == null) {
            this.substitution = new CodeableConcept();
        }
        return this.substitution;
    }

    @ExpectsValidResource
    public SubstanceAdministrationSubstitutionCode resolveSubstitution() throws InvalidEmedContentException {
        if (!this.hasSubstitution()) {
            return SubstanceAdministrationSubstitutionCode.EQUIVALENT;
        }
        SubstanceAdministrationSubstitutionCode substitutionCode = SubstanceAdministrationSubstitutionCode.fromCoding(this.getSubstitution().getCodingFirstRep());
        if (substitutionCode == null) {
            throw new InvalidEmedContentException("The substitution code is invalid");
        }
        return substitutionCode;
    }

    @ExpectsValidResource
    public ChEmedEprMedication resolveMedication() throws InvalidEmedContentException {
        Reference ref;
        IBaseResource resource;
        if (!this.hasMedication()) {
            throw new InvalidEmedContentException("The medication is missing in the medication statement");
        }
        Type reference = this.getMedication();
        if (reference instanceof Reference && (resource = (ref = (Reference)reference).getResource()) instanceof ChEmedEprMedication) {
            ChEmedEprMedication chMedication = (ChEmedEprMedication)resource;
            return chMedication;
        }
        throw new InvalidEmedContentException("The medication is invalid");
    }

    @Override
    @ExpectsValidResource
    public UUID resolveIdentifier() throws InvalidEmedContentException {
        if (!this.hasIdentifier()) {
            throw new InvalidEmedContentException("The ID is missing.");
        }
        return Uuids.parseUrnEncoded((String)this.getIdentifierFirstRep().getValue());
    }

    @ExpectsValidResource
    public ChEmedEprDosage resolveBaseDosage() throws InvalidEmedContentException {
        Dosage dosage;
        if (!this.getDosage().isEmpty() && (dosage = this.getDosage().get(0)) instanceof ChEmedEprDosage) {
            ChEmedEprDosage dosage2 = (ChEmedEprDosage)dosage;
            return dosage2;
        }
        throw new InvalidEmedContentException("Base entry of the dosage instruction is missing.");
    }

    public List<ChEmedEprDosage> resolveAdditionalDosage() {
        return this.getDosage().stream().filter(ChEmedEprDosage.class::isInstance).map(ChEmedEprDosage.class::cast).skip(1L).toList();
    }

    public boolean hasTreatmentReason() {
        return this.reasonCode != null && this.getReasonCodeFirstRep().hasText();
    }

    public @Nullable String getTreatmentReason() {
        if (this.reasonCode == null || !this.getReasonCodeFirstRep().hasText()) {
            return null;
        }
        return this.getReasonCodeFirstRep().getText();
    }

    public ChEmedEprMedicationStatement setTreatmentReason(String treatmentReason) {
        this.getReasonCodeFirstRep().setText(treatmentReason);
        return this;
    }

    public ChEmedEprMedicationStatement setIdentifier(UUID documentUUID) {
        Identifier identifier = this.getIdentifierFirstRep();
        if (identifier == null) {
            identifier = new Identifier();
            identifier.setSystem("urn:ietf:rfc:3986");
        }
        identifier.setValue("urn:uuid:" + documentUUID);
        return this;
    }

    public ChEmedEprMedicationStatement setDosageBaseEntry(ChEmedEprDosage dosageBaseEntry) {
        if (this.hasDosage()) {
            this.getDosage().set(0, dosageBaseEntry);
        } else {
            this.getDosage().add(dosageBaseEntry);
        }
        return this;
    }

    public ChEmedEprMedicationStatement setSubstitutionElement(CodeableConcept value) {
        this.substitution = value;
        return this;
    }

    public ChEmedEprMedicationStatement setSubstitution(SubstanceAdministrationSubstitutionCode value) {
        this.setSubstitutionElement(value.getCodeableConcept());
        return this;
    }

    public ChEmedEprMedicationStatement addDosageAdditionalEntry(ChEmedEprDosage dosageAdditionalEntry) {
        this.getDosage().add(dosageAdditionalEntry);
        return this;
    }

    public boolean hasSubstitution() {
        return this.substitution != null && !this.substitution.isEmpty();
    }

    public boolean hasDosageBaseEntry() {
        return this.hasDosage();
    }

    public boolean hasDosageAdditionalEntry() {
        return this.hasDosage() && this.getDosage().size() > 1;
    }

    public List<Dosage> getDosage() {
        if (this.dosage == null) {
            this.dosage = new ArrayList();
        } else {
            for (int i = 0; i < this.dosage.size(); ++i) {
                if (this.dosage.get(i) instanceof ChEmedEprDosage) continue;
                ChEmedEprDosage newDosage = new ChEmedEprDosage();
                ((Dosage)this.dosage.get(i)).copyValues((Dosage)newDosage);
                this.dosage.set(i, newDosage);
            }
        }
        return this.dosage;
    }

    public MedicationStatement setDosage(List<Dosage> theDosage) {
        return super.setDosage(theDosage);
    }

    public ChEmedEprDosage addDosage() {
        ChEmedEprDosage dosage = new ChEmedEprDosage();
        this.addDosage(dosage);
        return dosage;
    }

    public MedicationStatement addDosage(Dosage t) {
        if (t instanceof ChEmedEprDosage) {
            ChEmedEprDosage chEmedEprDosage = (ChEmedEprDosage)t;
            this.dosage.add(chEmedEprDosage);
            return this;
        }
        ChEmedEprDosage newDosage = new ChEmedEprDosage();
        t.copyValues((Dosage)newDosage);
        this.dosage.add(newDosage);
        return this;
    }

    public ChEmedEprDosage getDosageFirstRep() {
        if (this.getDosage().isEmpty()) {
            this.addDosage();
        }
        return (ChEmedEprDosage)this.getDosage().get(0);
    }

    @ExpectsValidResource
    public EffectiveDosageInstructions resolveEffectiveDosageInstructions() {
        return EffectiveDosageInstructions.fromDosages(this.resolveBaseDosage(), this.resolveAdditionalDosage());
    }

    @ExpectsValidResource
    public @Nullable Author resolveInformationSource() {
        if (!this.hasInformationSource()) {
            return null;
        }
        return new Author(this.getInformationSource().getResource());
    }

    @ExpectsValidResource
    public ChCorePatientEpr resolveSubject() {
        IBaseResource iBaseResource;
        if (this.hasSubject() && (iBaseResource = this.getSubject().getResource()) instanceof ChCorePatientEpr) {
            ChCorePatientEpr patient = (ChCorePatientEpr)iBaseResource;
            return patient;
        }
        throw new InvalidEmedContentException("The subject (Patient) is missing");
    }

    public void copyValues(MedicationStatement dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprMedicationStatement) {
            ChEmedEprMedicationStatement als = (ChEmedEprMedicationStatement)dst;
            als.substitution = this.substitution == null ? null : this.substitution.copy();
        }
    }
}

