/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.MedicationRequest;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;
import org.projecthusky.common.utils.datatypes.Uuids;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedEntryType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedEprDosage;
import org.projecthusky.fhir.emed.ch.epr.enums.PrescriptionStatus;
import org.projecthusky.fhir.emed.ch.epr.enums.SubstanceAdministrationSubstitutionCode;
import org.projecthusky.fhir.emed.ch.epr.model.common.EffectiveDosageInstructions;
import org.projecthusky.fhir.emed.ch.epr.model.common.EmedReference;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprEntry;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprMedication;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtTreatmentPlan;
import org.projecthusky.fhir.emed.ch.epr.util.References;

public abstract class ChEmedEprMedicationRequest
extends MedicationRequest
implements ChEmedEprEntry {
    @Child(name="treatmentplan", min=1)
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-treatmentplan", definedLocally=false)
    protected @Nullable ChEmedExtTreatmentPlan treatmentPlan;

    public ChEmedEprMedicationRequest() {
        this.setStatus(MedicationRequest.MedicationRequestStatus.COMPLETED);
        this.setIntent(MedicationRequest.MedicationRequestIntent.ORDER);
    }

    public ChEmedEprMedicationRequest(UUID entryUuid) {
        this.setStatus(MedicationRequest.MedicationRequestStatus.COMPLETED);
        this.setIntent(MedicationRequest.MedicationRequestIntent.ORDER);
        this.addIdentifier().setValue("urn:uuid:" + entryUuid).setSystem("urn:ietf:rfc:3986");
    }

    @Override
    public EmedEntryType getEmedType() {
        return EmedEntryType.PRE;
    }

    @Override
    @ExpectsValidResource
    public UUID resolveIdentifier() throws InvalidEmedContentException {
        if (!this.hasIdentifier()) {
            throw new InvalidEmedContentException("The ID is missing");
        }
        return Uuids.parseUrnEncoded((String)this.getIdentifierFirstRep().getValue());
    }

    @ExpectsValidResource
    public ChEmedEprMedication resolveMedication() throws InvalidEmedContentException {
        if (!this.hasMedicationReference()) {
            throw new InvalidEmedContentException("The medication reference is missing");
        }
        IBaseResource resource = this.getMedicationReference().getResource();
        if (resource instanceof ChEmedEprMedication) {
            ChEmedEprMedication chMedication = (ChEmedEprMedication)resource;
            return chMedication;
        }
        throw new InvalidEmedContentException("The medication resource isn't of the right type");
    }

    @ExpectsValidResource
    public ChCorePatientEpr resolvePatient() throws InvalidEmedContentException {
        if (!this.hasSubject()) {
            throw new InvalidEmedContentException("The patient is missing");
        }
        IBaseResource resource = this.getSubject().getResource();
        if (resource instanceof ChCorePatientEpr) {
            ChCorePatientEpr chPatient = (ChCorePatientEpr)resource;
            return chPatient;
        }
        throw new InvalidEmedContentException("The patient resource isn't of the right type");
    }

    @ExpectsValidResource
    public ChEmedEprDosage resolveBaseDosage() throws InvalidEmedContentException {
        Dosage dosage;
        if (!this.getDosageInstruction().isEmpty() && (dosage = this.getDosageInstruction().get(0)) instanceof ChEmedEprDosage) {
            ChEmedEprDosage dosage2 = (ChEmedEprDosage)dosage;
            return dosage2;
        }
        throw new InvalidEmedContentException("Base entry of the dosage instruction is missing");
    }

    @ExpectsValidResource
    public EmedReference resolveMtpReference() throws InvalidEmedContentException {
        if (!this.hasTreatmentPlan()) {
            throw new InvalidEmedContentException("The treatment plan reference is missing");
        }
        return this.getTreatmentPlanElement().resolveReference();
    }

    public List<ChEmedEprDosage> resolveAdditionalDosage() {
        return this.getDosageInstruction().stream().filter(ChEmedEprDosage.class::isInstance).map(ChEmedEprDosage.class::cast).skip(1L).toList();
    }

    @ExpectsValidResource
    public PrescriptionStatus resolveStatus() throws InvalidEmedContentException {
        if (!this.hasStatus()) {
            throw new InvalidEmedContentException("The status is missing.");
        }
        return switch (this.getStatus()) {
            default -> throw new IncompatibleClassChangeError();
            case MedicationRequest.MedicationRequestStatus.ACTIVE -> PrescriptionStatus.ACTIVE;
            case MedicationRequest.MedicationRequestStatus.ONHOLD, MedicationRequest.MedicationRequestStatus.DRAFT -> PrescriptionStatus.SUBMITTED;
            case MedicationRequest.MedicationRequestStatus.CANCELLED, MedicationRequest.MedicationRequestStatus.STOPPED -> PrescriptionStatus.CANCELED;
            case MedicationRequest.MedicationRequestStatus.ENTEREDINERROR -> PrescriptionStatus.REFUSED;
            case MedicationRequest.MedicationRequestStatus.COMPLETED, MedicationRequest.MedicationRequestStatus.UNKNOWN, MedicationRequest.MedicationRequestStatus.NULL -> throw new InvalidEmedContentException("The status is not supported");
        };
    }

    public ChEmedExtTreatmentPlan getTreatmentPlanElement() {
        if (this.treatmentPlan == null) {
            this.treatmentPlan = new ChEmedExtTreatmentPlan();
        }
        return this.treatmentPlan;
    }

    public ChEmedEprMedicationRequest setTreatmentPlanElement(ChEmedExtTreatmentPlan treatmentPlan) {
        this.treatmentPlan = treatmentPlan;
        return this;
    }

    public ChEmedEprMedicationRequest setIdentifier(UUID documentUUID) {
        Identifier identifier = this.getIdentifierFirstRep();
        if (identifier == null) {
            identifier = new Identifier();
            identifier.setSystem("urn:ietf:rfc:3986");
        }
        identifier.setValue("urn:uuid:" + documentUUID);
        return this;
    }

    public ChEmedEprMedicationRequest setMedicationReference(ChEmedEprMedication chEmedEprMedication) {
        this.setMedication((Type)References.createReference((Resource)chEmedEprMedication));
        return this;
    }

    public ChEmedEprMedicationRequest setPatient(ChCorePatientEpr chCorePatientEpr) {
        this.setSubject(References.createReference((Resource)chCorePatientEpr));
        return this;
    }

    public ChEmedEprMedicationRequest setDosageBaseEntry(ChEmedEprDosage dosageBaseEntry) {
        if (this.hasDosageInstruction()) {
            this.getDosageInstruction().set(0, dosageBaseEntry);
        } else {
            this.getDosageInstruction().add(dosageBaseEntry);
        }
        return this;
    }

    public ChEmedEprMedicationRequest addDosageAdditionalEntry(ChEmedEprDosage dosageAdditionalEntry) {
        this.getDosageInstruction().add(dosageAdditionalEntry);
        return this;
    }

    public boolean hasTreatmentPlan() {
        return this.treatmentPlan != null && !this.treatmentPlan.isEmpty();
    }

    public boolean hasDosageBaseEntry() {
        return this.hasDosageInstruction();
    }

    public boolean hasDosageAdditionalEntry() {
        return this.hasDosageInstruction() && this.getDosageInstruction().size() > 1;
    }

    public List<Dosage> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList();
        } else {
            for (int i = 0; i < this.dosageInstruction.size(); ++i) {
                if (this.dosageInstruction.get(i) instanceof ChEmedEprDosage) continue;
                ChEmedEprDosage newDosage = new ChEmedEprDosage();
                ((Dosage)this.dosageInstruction.get(i)).copyValues((Dosage)newDosage);
                this.dosageInstruction.set(i, newDosage);
            }
        }
        return this.dosageInstruction;
    }

    public MedicationRequest setDosageInstruction(List<Dosage> theDosage) {
        return super.setDosageInstruction(theDosage);
    }

    public ChEmedEprDosage addDosageInstruction() {
        ChEmedEprDosage dosage = new ChEmedEprDosage();
        this.addDosageInstruction(dosage);
        return dosage;
    }

    public MedicationRequest addDosageInstruction(Dosage t) {
        if (t instanceof ChEmedEprDosage) {
            ChEmedEprDosage chEmedEprDosage = (ChEmedEprDosage)t;
            this.dosageInstruction.add(chEmedEprDosage);
            return this;
        }
        ChEmedEprDosage newDosage = new ChEmedEprDosage();
        t.copyValues((Dosage)newDosage);
        this.dosageInstruction.add(newDosage);
        return this;
    }

    public ChEmedEprDosage getDosageInstructionFirstRep() {
        if (this.getDosageInstruction().isEmpty()) {
            this.addDosageInstruction();
        }
        return (ChEmedEprDosage)this.getDosageInstruction().get(0);
    }

    @ExpectsValidResource
    public EffectiveDosageInstructions resolveEffectiveDosageInstructions() {
        return EffectiveDosageInstructions.fromDosages(this.resolveBaseDosage(), this.resolveAdditionalDosage());
    }

    @ExpectsValidResource
    public ChCorePatientEpr resolveSubject() {
        IBaseResource iBaseResource;
        if (this.hasSubject() && (iBaseResource = this.getSubject().getResource()) instanceof ChCorePatientEpr) {
            ChCorePatientEpr patient = (ChCorePatientEpr)iBaseResource;
            return patient;
        }
        throw new InvalidEmedContentException("The subject (Patient) is missing");
    }

    @ExpectsValidResource
    public SubstanceAdministrationSubstitutionCode resolveSubstitution() throws InvalidEmedContentException {
        if (!this.hasSubstitution() || !this.getSubstitution().hasAllowedCodeableConcept()) {
            return SubstanceAdministrationSubstitutionCode.EQUIVALENT;
        }
        SubstanceAdministrationSubstitutionCode substitutionCode = SubstanceAdministrationSubstitutionCode.fromCoding(this.getSubstitution().getAllowedCodeableConcept().getCodingFirstRep());
        if (substitutionCode == null) {
            throw new InvalidEmedContentException("The substitution code is invalid");
        }
        return substitutionCode;
    }

    public void copyValues(MedicationRequest dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprMedicationRequest) {
            ChEmedEprMedicationRequest rst = (ChEmedEprMedicationRequest)dst;
            rst.treatmentPlan = this.treatmentPlan == null ? null : this.treatmentPlan.copy();
        }
    }
}

