/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.Ratio;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.ActivePharmaceuticalIngredient;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedRatioWithEmedUnits;

public class ChEmedEprMedicationIngredient
extends Medication.MedicationIngredientComponent {
    @ExpectsValidResource
    public @Nullable ChEmedRatioWithEmedUnits resolveStrength() throws InvalidEmedContentException {
        if (!this.hasStrength()) {
            return null;
        }
        Ratio ratio = this.getStrength();
        if (ratio instanceof ChEmedRatioWithEmedUnits) {
            ChEmedRatioWithEmedUnits chRatio = (ChEmedRatioWithEmedUnits)ratio;
            return chRatio;
        }
        throw new InvalidEmedContentException("The dose per unit isn't of the right type.");
    }

    @ExpectsValidResource
    public ActivePharmaceuticalIngredient resolveActiveIngredient() throws InvalidEmedContentException {
        if (!this.hasItemCodeableConcept()) {
            throw new InvalidEmedContentException("The active ingredient is missing.");
        }
        ActivePharmaceuticalIngredient ingredient = ActivePharmaceuticalIngredient.getEnum((String)this.getItemCodeableConcept().getCodingFirstRep().getCode());
        if (ingredient != null) {
            return ingredient;
        }
        throw new InvalidEmedContentException("The active ingredient name is unknown.");
    }

    public ChEmedEprMedicationIngredient setStrength(ChEmedRatioWithEmedUnits ratio) {
        super.setStrength((Ratio)ratio);
        return this;
    }

    public ChEmedEprMedicationIngredient setActiveIngredient(ActivePharmaceuticalIngredient ingredient) {
        this.getItemCodeableConcept().setText(ingredient.getDisplayName()).getCodingFirstRep().setSystem("urn:oid:" + ingredient.getCodeSystemId()).setCode(ingredient.getCodeValue()).setDisplay(ingredient.getDisplayName());
        this.setIsActive(true);
        return this;
    }

    public ChEmedEprMedicationIngredient copy() {
        ChEmedEprMedicationIngredient copy = new ChEmedEprMedicationIngredient();
        this.copyValues(copy);
        return copy;
    }
}

