/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import java.sql.Date;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.Type;
import org.projecthusky.common.utils.datatypes.Uuids;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedEntryType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedEprDosage;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedQuantityWithEmedUnits;
import org.projecthusky.fhir.emed.ch.epr.model.common.EffectiveDosageInstructions;
import org.projecthusky.fhir.emed.ch.epr.model.common.EmedReference;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprEntry;
import org.projecthusky.fhir.emed.ch.epr.resource.dis.ChEmedEprMedicationDis;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtPharmaceuticalAdvice;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtPrescription;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChEmedExtTreatmentPlan;
import org.projecthusky.fhir.emed.ch.epr.util.References;

public abstract class ChEmedEprMedicationDispense
extends MedicationDispense
implements ChEmedEprEntry {
    @Child(name="treatmentReason")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-treatmentreason", definedLocally=false)
    protected @Nullable StringType treatmentReason;
    @Child(name="prescription")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-prescription", definedLocally=false)
    protected @Nullable ChEmedExtPrescription prescription;
    @Child(name="pharmaceuticalAdvice")
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-pharmaceuticaladvice", definedLocally=false)
    protected @Nullable ChEmedExtPharmaceuticalAdvice pharmaceuticalAdvice;
    @Child(name="treatmentPlan", min=1)
    @Extension(url="http://fhir.ch/ig/ch-emed/StructureDefinition/ch-emed-ext-treatmentplan", definedLocally=false)
    protected @Nullable ChEmedExtTreatmentPlan treatmentPlan;

    public ChEmedEprMedicationDispense() {
    }

    public ChEmedEprMedicationDispense(UUID entryUuid, Instant whenHandedOver) {
        this.setStatus(MedicationDispense.MedicationDispenseStatus.COMPLETED);
        this.getIdentifierFirstRep().setValue("urn:uuid:" + entryUuid).setSystem("urn:ietf:rfc:3986");
        this.setWhenHandedOver(Date.from(whenHandedOver));
    }

    @Override
    @ExpectsValidResource
    public UUID resolveIdentifier() throws InvalidEmedContentException {
        if (!this.hasIdentifier()) {
            throw new InvalidEmedContentException("The ID is missing");
        }
        return Uuids.parseUrnEncoded((String)this.getIdentifierFirstRep().getValue());
    }

    @ExpectsValidResource
    public ChEmedEprMedicationDis resolveMedication() throws InvalidEmedContentException {
        if (!this.hasMedicationReference()) {
            throw new InvalidEmedContentException("The medication reference is missing");
        }
        IBaseResource resource = this.getMedicationReference().getResource();
        if (resource instanceof ChEmedEprMedicationDis) {
            ChEmedEprMedicationDis chMedication = (ChEmedEprMedicationDis)resource;
            return chMedication;
        }
        throw new InvalidEmedContentException("The medication resource isn't of the right type");
    }

    @ExpectsValidResource
    public ChEmedQuantityWithEmedUnits resolveQuantity() throws InvalidEmedContentException {
        if (!this.hasQuantity()) {
            throw new InvalidEmedContentException("The number of packages is missing");
        }
        Quantity quantity = this.getQuantity();
        if (quantity instanceof ChEmedQuantityWithEmedUnits) {
            ChEmedQuantityWithEmedUnits chQuantity = (ChEmedQuantityWithEmedUnits)quantity;
            return chQuantity;
        }
        throw new InvalidEmedContentException("The quantity isn't of the right type");
    }

    @ExpectsValidResource
    public Instant resolveWhenHandedOver() throws InvalidEmedContentException {
        if (!this.hasWhenHandedOver()) {
            throw new InvalidEmedContentException("the date/time of when the product was distributed is missing.");
        }
        return this.getWhenHandedOver().toInstant();
    }

    @ExpectsValidResource
    public ChEmedEprDosage resolveBaseDosage() throws InvalidEmedContentException {
        Dosage dosage;
        if (!this.getDosageInstruction().isEmpty() && (dosage = this.getDosageInstruction().get(0)) instanceof ChEmedEprDosage) {
            ChEmedEprDosage dosage2 = (ChEmedEprDosage)dosage;
            return dosage2;
        }
        throw new InvalidEmedContentException("Base entry of the dosage instruction is missing");
    }

    @ExpectsValidResource
    public EmedReference resolveMtpReference() throws InvalidEmedContentException {
        if (!this.hasTreatmentPlan()) {
            throw new InvalidEmedContentException("The treatment plan reference is missing");
        }
        return this.getTreatmentPlanElement().resolveReference();
    }

    @ExpectsValidResource
    public @Nullable EmedReference resolvePreReference() throws InvalidEmedContentException {
        if (!this.hasPrescription()) {
            return null;
        }
        return this.getPrescriptionElement().resolveReference();
    }

    public List<ChEmedEprDosage> resolveAdditionalDosage() {
        return this.getDosageInstruction().stream().filter(ChEmedEprDosage.class::isInstance).map(ChEmedEprDosage.class::cast).skip(1L).toList();
    }

    @Override
    public EmedEntryType getEmedType() {
        return EmedEntryType.DIS;
    }

    public StringType getTreatmentReason() {
        if (this.treatmentReason == null) {
            this.treatmentReason = new StringType();
        }
        return this.treatmentReason;
    }

    public ChEmedEprMedicationDispense setTreatmentReason(String treatmentReason) {
        this.getTreatmentReason().setValue((Object)treatmentReason);
        return this;
    }

    public ChEmedExtPrescription getPrescriptionElement() {
        if (this.prescription == null) {
            this.prescription = new ChEmedExtPrescription();
        }
        return this.prescription;
    }

    public ChEmedEprMedicationDispense setPrescriptionElement(ChEmedExtPrescription prescription) {
        this.prescription = prescription;
        return this;
    }

    public ChEmedExtPharmaceuticalAdvice getPharmaceuticalAdviceElement() {
        if (this.pharmaceuticalAdvice == null) {
            this.pharmaceuticalAdvice = new ChEmedExtPharmaceuticalAdvice();
        }
        return this.pharmaceuticalAdvice;
    }

    public ChEmedEprMedicationDispense setPharmaceuticalAdviceElement(ChEmedExtPharmaceuticalAdvice pharmaceuticalAdvice) {
        this.pharmaceuticalAdvice = pharmaceuticalAdvice;
        return this;
    }

    public ChEmedExtTreatmentPlan getTreatmentPlanElement() {
        if (this.treatmentPlan == null) {
            this.treatmentPlan = new ChEmedExtTreatmentPlan();
        }
        return this.treatmentPlan;
    }

    public ChEmedEprMedicationDispense setTreatmentPlanElement(ChEmedExtTreatmentPlan treatmentPlan) {
        this.treatmentPlan = treatmentPlan;
        return this;
    }

    public ChEmedEprMedicationDispense setIdentifier(UUID identifier) {
        if (!this.hasIdentifier()) {
            this.getIdentifierFirstRep().setSystem("urn:ietf:rfc:3986");
        }
        this.getIdentifierFirstRep().setValue("urn:uuid:" + identifier);
        return this;
    }

    public ChEmedEprMedicationDispense setMedicationReference(ChEmedEprMedicationDis chEmedEprMedication) {
        this.setMedication((Type)References.createReference((Resource)chEmedEprMedication));
        this.addContained((Resource)chEmedEprMedication);
        return this;
    }

    public ChEmedEprMedicationDispense setQuantity(int quantity) {
        this.getQuantity().setValue((long)quantity);
        return this;
    }

    public ChEmedEprMedicationDispense setWhenHandedOver(Instant whenHandedOver) {
        super.setWhenHandedOver(Date.from(whenHandedOver));
        return this;
    }

    public ChEmedEprMedicationDispense setDosageBaseEntry(ChEmedEprDosage dosageBaseEntry) {
        if (this.hasDosageInstruction()) {
            this.getDosageInstruction().set(0, dosageBaseEntry);
        } else {
            this.getDosageInstruction().add(dosageBaseEntry);
        }
        return this;
    }

    public ChEmedEprMedicationDispense addDosageAdditionalEntry(ChEmedEprDosage dosageAdditionalEntry) {
        this.getDosageInstruction().add(dosageAdditionalEntry);
        return this;
    }

    public boolean hasTreatmentReason() {
        return this.treatmentReason != null && !this.treatmentReason.isEmpty();
    }

    public boolean hasPrescription() {
        return this.prescription != null && !this.prescription.isEmpty();
    }

    public boolean hasPharmaceuticalAdvice() {
        return this.pharmaceuticalAdvice != null;
    }

    public boolean hasTreatmentPlan() {
        return this.treatmentPlan != null && !this.treatmentPlan.isEmpty();
    }

    public boolean hasDosageBaseEntry() {
        return this.hasDosageInstruction();
    }

    public boolean hasDosageAdditionalEntry() {
        return this.hasDosageInstruction() && this.getDosageInstruction().size() > 1;
    }

    public List<Dosage> getDosageInstruction() {
        if (this.dosageInstruction == null) {
            this.dosageInstruction = new ArrayList();
        } else {
            for (int i = 0; i < this.dosageInstruction.size(); ++i) {
                if (this.dosageInstruction.get(i) instanceof ChEmedEprDosage) continue;
                ChEmedEprDosage newDosage = new ChEmedEprDosage();
                ((Dosage)this.dosageInstruction.get(i)).copyValues((Dosage)newDosage);
                this.dosageInstruction.set(i, newDosage);
            }
        }
        return this.dosageInstruction;
    }

    public MedicationDispense setDosageInstruction(List<Dosage> theDosage) {
        return super.setDosageInstruction(theDosage);
    }

    public ChEmedEprDosage addDosageInstruction() {
        ChEmedEprDosage dosage = new ChEmedEprDosage();
        this.addDosageInstruction(dosage);
        return dosage;
    }

    public MedicationDispense addDosageInstruction(Dosage t) {
        if (t instanceof ChEmedEprDosage) {
            ChEmedEprDosage chEmedEprDosage = (ChEmedEprDosage)t;
            this.dosageInstruction.add(chEmedEprDosage);
            return this;
        }
        ChEmedEprDosage newDosage = new ChEmedEprDosage();
        t.copyValues((Dosage)newDosage);
        this.dosageInstruction.add(newDosage);
        return this;
    }

    public ChEmedEprDosage getDosageInstructionFirstRep() {
        if (this.getDosageInstruction().isEmpty()) {
            this.addDosageInstruction();
        }
        return (ChEmedEprDosage)this.getDosageInstruction().get(0);
    }

    @ExpectsValidResource
    public EffectiveDosageInstructions resolveEffectiveDosageInstructions() {
        return EffectiveDosageInstructions.fromDosages(this.resolveBaseDosage(), this.resolveAdditionalDosage());
    }

    @ExpectsValidResource
    public ChCorePatientEpr resolveSubject() {
        IBaseResource iBaseResource;
        if (this.hasSubject() && (iBaseResource = this.getSubject().getResource()) instanceof ChCorePatientEpr) {
            ChCorePatientEpr patient = (ChCorePatientEpr)iBaseResource;
            return patient;
        }
        throw new InvalidEmedContentException("The subject (Patient) is missing");
    }

    public void copyValues(MedicationDispense dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprMedicationDispense) {
            ChEmedEprMedicationDispense als = (ChEmedEprMedicationDispense)dst;
            als.treatmentReason = this.treatmentReason == null ? null : this.treatmentReason.copy();
            als.prescription = this.prescription == null ? null : this.prescription.copy();
            als.pharmaceuticalAdvice = this.pharmaceuticalAdvice == null ? null : this.pharmaceuticalAdvice.copy();
            als.treatmentPlan = this.treatmentPlan == null ? null : this.treatmentPlan.copy();
        }
    }
}

