/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Medication;
import org.hl7.fhir.r4.model.OidType;
import org.hl7.fhir.r4.model.UriType;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.PharmaceuticalDoseFormEdqm;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprMedicationIngredient;

@ResourceDef(profile="https://fhir.cara.ch/StructureDefinition/ch-emed-epr-medication")
public class ChEmedEprMedication
extends Medication {
    @ExpectsValidResource
    public @Nullable String resolveGtinCode() {
        return this.hasGtin() ? this.getCode().getCodingFirstRep().getCode() : null;
    }

    @ExpectsValidResource
    public @Nullable String resolveAtcCode() {
        return this.hasAtc() ? this.getCode().getCodingFirstRep().getCode() : null;
    }

    @ExpectsValidResource
    public String resolveMedicationName() throws InvalidEmedContentException {
        if (!this.hasCode() && this.getCode().getText() == null) {
            throw new InvalidEmedContentException("The medication name is not specified");
        }
        return this.getCode().getText();
    }

    public ChEmedEprMedication setGtin(String gtin, String displayName) {
        UriType system = new UriType("urn:oid:2.51.1.1");
        Coding coding = new Coding().setSystemElement(system).setCode(gtin).setDisplay(displayName);
        CodeableConcept code = new CodeableConcept(coding).setText(displayName);
        this.setCode(code);
        return this;
    }

    public ChEmedEprMedication setAtc(String atc, String displayName) {
        UriType system = new UriType("urn:oid:2.16.840.1.113883.6.73");
        Coding coding = new Coding().setSystemElement(system).setCode(atc).setDisplay(displayName);
        CodeableConcept code = new CodeableConcept(coding).setText(displayName);
        this.setCode(code);
        return this;
    }

    public boolean hasGtin() {
        if (!this.hasCode() && !this.getCode().hasCoding()) {
            return false;
        }
        return this.getCode().getCodingFirstRep().getSystem().equals("urn:oid:2.51.1.1");
    }

    public boolean hasAtc() {
        if (!this.hasCode() && !this.getCode().hasCoding()) {
            return false;
        }
        return this.getCode().getCodingFirstRep().getSystem().equals("urn:oid:2.16.840.1.113883.6.73");
    }

    @ExpectsValidResource
    public PharmaceuticalDoseFormEdqm resolveForm() throws InvalidEmedContentException {
        if (!this.hasForm()) {
            throw new InvalidEmedContentException("The form is not specified");
        }
        PharmaceuticalDoseFormEdqm edqmForm = PharmaceuticalDoseFormEdqm.getEnum((String)this.getForm().getCodingFirstRep().getCode());
        if (edqmForm == null) {
            throw new InvalidEmedContentException("The form is not referenced in the value set PharmaceuticalDoseFormEDQM");
        }
        return edqmForm;
    }

    @ExpectsValidResource
    public List<ChEmedEprMedicationIngredient> resolveActiveIngredients() {
        return this.getIngredient().stream().filter(Medication.MedicationIngredientComponent::getIsActive).filter(ChEmedEprMedicationIngredient.class::isInstance).map(ChEmedEprMedicationIngredient.class::cast).toList();
    }

    public ChEmedEprMedication setForm(PharmaceuticalDoseFormEdqm doseForm) {
        OidType system = UriType.fromOid((String)doseForm.getCodeSystemId());
        Coding coding = new Coding().setSystemElement((UriType)system).setCode(doseForm.getCodeValue()).setDisplay(doseForm.getDisplayName());
        this.setForm(new CodeableConcept(coding));
        return this;
    }

    public ChEmedEprMedication addActiveIngredient(ChEmedEprMedicationIngredient ingredient) {
        super.addIngredient((Medication.MedicationIngredientComponent)ingredient);
        return this;
    }

    public ChEmedEprMedication copy() {
        ChEmedEprMedication copy = new ChEmedEprMedication();
        this.copyValues(copy);
        return copy;
    }
}

