/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import java.sql.Date;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Resource;
import org.projecthusky.common.utils.datatypes.Uuids;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprComposition;

public abstract class ChEmedEprDocument
extends Bundle {
    protected ChEmedEprDocument() {
    }

    protected ChEmedEprDocument(UUID documentId, Instant timestamp) {
        Objects.requireNonNull(documentId, "documentId shall not be null in ChEmedEprDocument()");
        Objects.requireNonNull(timestamp, "timestamp shall not be null in ChEmedEprDocument()");
        this.setType(Bundle.BundleType.DOCUMENT);
        this.setIdentifier(new Identifier());
        this.getIdentifier().setSystem("urn:ietf:rfc:3986");
        this.getIdentifier().setValue("urn:uuid:" + documentId);
        this.setTimestamp(Date.from(timestamp));
    }

    public abstract ChEmedEprComposition resolveComposition();

    public abstract EmedDocumentType getEmedType();

    public abstract Bundle.BundleEntryComponent getCompositionEntry();

    @ExpectsValidResource
    public UUID resolveIdentifier() throws InvalidEmedContentException {
        if (!this.hasIdentifier()) {
            throw new InvalidEmedContentException("The ID is missing.");
        }
        return Uuids.parseUrnEncoded((String)this.getIdentifier().getValue());
    }

    @ExpectsValidResource
    public ChCorePatientEpr resolvePatient() throws InvalidEmedContentException {
        Resource resource;
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChCorePatientEpr.class);
        if (entry != null && (resource = entry.getResource()) instanceof ChCorePatientEpr) {
            ChCorePatientEpr patient = (ChCorePatientEpr)resource;
            return patient;
        }
        throw new InvalidEmedContentException("The ChCorePatientEpr is missing in the document Bundle");
    }

    @ExpectsValidResource
    public Instant resolveTimestamp() throws InvalidEmedContentException {
        if (!this.hasTimestamp()) {
            throw new InvalidEmedContentException("The document timestamp is missing");
        }
        return this.getTimestamp().toInstant();
    }

    public ChEmedEprDocument setCreationTime(Instant creationTime) {
        this.setTimestamp(Date.from(creationTime));
        return this;
    }

    public ChEmedEprDocument setIdentifier(UUID documentUUID) {
        Identifier identifier = this.getIdentifier();
        if (identifier == null) {
            identifier = new Identifier();
        }
        identifier.setSystem("urn:ietf:rfc:3986");
        identifier.setValue("urn:uuid:" + documentUUID);
        return this;
    }

    public Bundle.BundleEntryComponent setPatient(ChCorePatientEpr patient) {
        Bundle.BundleEntryComponent entry = this.getEntryByResourceType(ChCorePatientEpr.class);
        if (entry == null) {
            entry = this.addEntry();
        }
        entry.setResource((Resource)patient);
        return entry;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Bundle.BundleEntryComponent getEntryByResourceType(Class<?> resourceType) {
        return this.getEntry().stream().filter(entry -> resourceType.isInstance(entry.getResource())).findAny().orElse(null);
    }

    protected <T> List<T> getEntryResourceByResourceType(Class<T> resourceType) {
        return this.getEntry().stream().map(Bundle.BundleEntryComponent::getResource).filter(resourceType::isInstance).map(resourceType::cast).toList();
    }
}

