/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.resource;

import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Extension;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.BaseReference;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.PractitionerRole;
import org.hl7.fhir.r4.model.Reference;
import org.hl7.fhir.r4.model.RelatedPerson;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UnsignedIntType;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.utils.datatypes.Uuids;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.enums.CommonLanguages;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.common.resource.ChCorePatientEpr;
import org.projecthusky.fhir.emed.ch.common.resource.ChEmedOrganization;
import org.projecthusky.fhir.emed.ch.epr.resource.extension.ChExtEprDataEnterer;
import org.projecthusky.fhir.emed.ch.epr.util.References;

public abstract class ChEmedEprComposition
extends Composition {
    public static final String ORIGINAL_REPR_SECTION_CODE_VALUE = "55108-5";
    public static final String TREATMENT_PLAN_SECTION_CODE_VALUE = "77604-7";
    public static final String PRESCRIPTION_SECTION_CODE_VALUE = "57828-6";
    public static final String DISPENSE_SECTION_CODE_VALUE = "60590-7";
    public static final String PHARMACEUTICAL_ADVICE_SECTION_CODE_VALUE = "61357-0";
    public static final String LIST_SECTION_CODE_VALUE = "10160-0";
    public static final String CARD_SECTION_CODE_VALUE = "10160-0";
    public static final String ANNOTATION_SECTION_CODE_VALUE = "48767-8";
    public static final String VITAL_SIGNS_SECTION_CODE_VALUE = "29463-7";
    @Child(name="versionNumber")
    @Extension(url="http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-epr-versionnumber", definedLocally=false)
    protected @Nullable UnsignedIntType versionNumber;
    @Child(name="informationRecipient", min=1, max=-1)
    @Extension(url="http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-epr-informationrecipient", definedLocally=false)
    protected @Nullable List<Reference> informationRecipient;
    @Child(name="dataEnterer")
    @Extension(url="http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-epr-dataenterer", definedLocally=false)
    protected @Nullable ChExtEprDataEnterer dataEnterer;

    public ChEmedEprComposition() {
    }

    public ChEmedEprComposition(UUID compositionId, Instant date, LanguageCode language) {
        this.setStatus(Composition.CompositionStatus.FINAL);
        this.setConfidentiality(Composition.DocumentConfidentiality.N);
        Coding confidentialityCode = new Coding("http://snomed.info/sct", "17621005", "Normal (qualifier value)");
        this.getConfidentialityElement().addExtension("http://fhir.ch/ig/ch-core/StructureDefinition/ch-ext-epr-confidentialitycode", (Type)new CodeableConcept().addCoding(confidentialityCode));
        this.getIdentifier().setSystem("urn:ietf:rfc:3986").setValue("urn:uuid:" + compositionId);
        this.setDate(Date.from(date));
        this.setLanguage(language.getCodeValue());
    }

    @ExpectsValidResource
    public ChCorePatientEpr resolvePatient() throws InvalidEmedContentException {
        return Optional.ofNullable(this.subject).map(BaseReference::getResource).map(ChCorePatientEpr.class::cast).orElseThrow(() -> new InvalidEmedContentException("The subject reference is missing or of wrong type"));
    }

    @ExpectsValidResource
    public ChEmedOrganization resolveCustodian() throws InvalidEmedContentException {
        return Optional.ofNullable(this.custodian).map(BaseReference::getResource).map(ChEmedOrganization.class::cast).orElseThrow(() -> new InvalidEmedContentException("The custodian reference is missing or of wrong type"));
    }

    @ExpectsValidResource
    public UUID resolveIdentifier() throws InvalidEmedContentException {
        if (!this.hasIdentifier()) {
            throw new InvalidEmedContentException("The ID is missing.");
        }
        return Uuids.parseUrnEncoded((String)this.getIdentifier().getValue());
    }

    @ExpectsValidResource
    public CommonLanguages resolveLanguage() {
        if (!this.hasLanguage()) {
            throw new InvalidEmedContentException("The language is missing.");
        }
        CommonLanguages code = CommonLanguages.getEnum((String)this.getLanguage());
        if (code == null) {
            throw new InvalidEmedContentException("The language is invalid.");
        }
        return code;
    }

    @ExpectsValidResource
    public Instant resolveDate() {
        if (!this.hasDate()) {
            throw new InvalidEmedContentException("The document's creation date and time is missing.");
        }
        return this.getDate().toInstant();
    }

    @ExpectsValidResource
    public IBaseResource resolveFirstHumanAuthor() {
        for (Reference author : this.getAuthor()) {
            if (!(author.getResource() instanceof Patient) && !(author.getResource() instanceof RelatedPerson) && !(author.getResource() instanceof PractitionerRole)) continue;
            return author.getResource();
        }
        throw new InvalidEmedContentException("The composition has no human author");
    }

    public UnsignedIntType getVersionNumberElement() {
        if (this.versionNumber == null) {
            this.versionNumber = new UnsignedIntType();
        }
        return this.versionNumber;
    }

    public ChEmedEprComposition setVersionNumberElement(UnsignedIntType versionNumber) {
        if (versionNumber.hasValue() && (Integer)versionNumber.getValue() < 0) {
            throw new IllegalArgumentException("The version number shall be positive or zero");
        }
        this.versionNumber = versionNumber;
        return this;
    }

    public int getVersionNumber() {
        return this.versionNumber == null || this.versionNumber.isEmpty() ? 0 : (Integer)this.versionNumber.getValue();
    }

    public ChEmedEprComposition setVersionNumber(int value) {
        if (this.versionNumber == null) {
            this.versionNumber = new UnsignedIntType();
        }
        this.versionNumber.setValue((Object)value);
        return this;
    }

    public List<Reference> getInformationRecipient() {
        if (this.informationRecipient == null) {
            this.informationRecipient = new ArrayList<Reference>(0);
        }
        return this.informationRecipient;
    }

    public ChEmedEprComposition setInformationRecipient(List<Reference> informationRecipient) {
        this.informationRecipient = informationRecipient;
        return this;
    }

    public ChExtEprDataEnterer getDataEnterer() {
        if (this.dataEnterer == null) {
            this.dataEnterer = new ChExtEprDataEnterer();
        }
        return this.dataEnterer;
    }

    public ChEmedEprComposition setDataEnterer(ChExtEprDataEnterer dataEnterer) {
        this.dataEnterer = dataEnterer;
        return this;
    }

    public ChEmedEprComposition setLanguage(CommonLanguages language) {
        this.setLanguage(language.getCodeValue());
        return this;
    }

    public Composition.SectionComponent getOriginalRepresentationSection() {
        Composition.SectionComponent section = this.getSectionByLoincCode(ORIGINAL_REPR_SECTION_CODE_VALUE);
        if (section == null) {
            section = this.addSection();
            section.getCode().addCoding(new Coding("http://loinc.org", ORIGINAL_REPR_SECTION_CODE_VALUE, "Clinical presentation"));
        }
        return section;
    }

    @ExpectsValidResource
    public byte[] getOriginalRepresentationPdf() throws InvalidEmedContentException {
        Binary binary;
        Composition.SectionComponent section = this.getOriginalRepresentationSection();
        if (!section.hasEntry()) {
            throw new InvalidEmedContentException("The section has no entries");
        }
        IBaseResource resource = ((Reference)section.getEntry().get(0)).getResource();
        if (resource instanceof Binary && (binary = (Binary)resource).hasData()) {
            return binary.getData();
        }
        throw new InvalidEmedContentException("The section isn't referencing a filled Binary resource");
    }

    public ChEmedEprComposition setOriginalRepresentationPdf(String title, Binary originalRepresentationPdf) {
        this.getOriginalRepresentationSection().setTitle(title).getEntryFirstRep().setReference(originalRepresentationPdf.getId()).setResource((IBaseResource)originalRepresentationPdf);
        return this;
    }

    protected // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable Composition.SectionComponent getSectionByLoincCode(String code) {
        return this.getSection().stream().filter(section -> section.getCode().hasCoding("http://loinc.org", code)).findAny().orElse(null);
    }

    public ChEmedEprComposition setIdentifier(UUID documentUUID) {
        Identifier identifier = this.getIdentifier();
        if (identifier == null) {
            identifier = new Identifier();
        }
        identifier.setSystem("urn:ietf:rfc:3986");
        identifier.setValue("urn:uuid:" + documentUUID);
        return this;
    }

    public ChEmedEprComposition setPatient(ChCorePatientEpr chCorePatientEpr) {
        this.setSubject(References.createReference((Resource)chCorePatientEpr));
        return this;
    }

    public boolean hasVersionNumber() {
        return this.versionNumber != null && !this.versionNumber.isEmpty();
    }

    public boolean hasInformationRecipient() {
        if (this.informationRecipient == null) {
            return false;
        }
        for (Reference item : this.informationRecipient) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasOriginalRepresentationSection() {
        return this.getSectionByLoincCode(ORIGINAL_REPR_SECTION_CODE_VALUE) != null;
    }

    public boolean hasVitalSignsSection() {
        return this.getSectionByLoincCode(VITAL_SIGNS_SECTION_CODE_VALUE) != null;
    }

    @ExpectsValidResource
    public @Nullable Observation resolvePatientWeightObservation() throws InvalidEmedContentException {
        return Optional.ofNullable(this.getSectionByLoincCode(VITAL_SIGNS_SECTION_CODE_VALUE)).map(Composition.SectionComponent::getEntry).map(entries -> !entries.isEmpty() ? (Reference)entries.get(0) : null).map(BaseReference::getResource).map(Observation.class::cast).orElse(null);
    }

    public boolean hasDataEnterer() {
        return this.dataEnterer != null && this.dataEnterer.hasEnterer();
    }

    public void copyValues(Composition dst) {
        super.copyValues(dst);
        if (dst instanceof ChEmedEprComposition) {
            ChEmedEprComposition als = (ChEmedEprComposition)dst;
            als.versionNumber = this.versionNumber == null ? null : this.versionNumber.copy();
            ChExtEprDataEnterer chExtEprDataEnterer = als.dataEnterer = this.dataEnterer == null ? null : this.dataEnterer.copy();
            if (this.informationRecipient != null) {
                als.informationRecipient = new ArrayList<Reference>();
                for (Reference i : this.informationRecipient) {
                    als.informationRecipient.add(i.copy());
                }
            }
        }
    }

    @Block
    public static class VitalSignsSection
    extends Composition.SectionComponent {
        public VitalSignsSection() {
            this.getCode().getCodingFirstRep().setCode(ChEmedEprComposition.VITAL_SIGNS_SECTION_CODE_VALUE).setSystem("http://loinc.org");
        }
    }
}

