/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.model.common;

import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.fhir.emed.ch.common.enums.EmedDocumentType;
import org.projecthusky.fhir.emed.ch.common.enums.EmedEntryType;

public class EmedReference {
    private @Nullable UUID documentId;
    private @Nullable UUID entryId;
    private @Nullable EmedDocumentType documentType;
    private @Nullable EmedEntryType entryType;

    public EmedReference(@Nullable UUID documentId, @Nullable UUID entryId) {
        if (documentId == null && entryId == null) {
            throw new IllegalArgumentException("The document and entry IDs shall not be both null");
        }
        this.documentId = documentId;
        this.entryId = entryId;
    }

    public EmedReference(@Nullable UUID documentId, @Nullable UUID entryId, @Nullable EmedDocumentType documentType, @Nullable EmedEntryType entryType) {
        if (documentId == null && entryId == null) {
            throw new IllegalArgumentException("The document and entry IDs shall not be both null");
        }
        this.documentId = documentId;
        this.entryId = entryId;
        this.documentType = documentType;
        this.entryType = entryType;
    }

    public boolean isEntryReference() {
        return this.entryId != null;
    }

    public String toText() {
        if (this.entryId != null) {
            if (this.documentId != null) {
                return String.format("entry '%s' (in document '%s')", this.entryId, this.documentId);
            }
            return String.format("entry '%s'", this.entryId);
        }
        return String.format("document '%s'", this.documentId);
    }

    public @Nullable UUID getDocumentId() {
        return this.documentId;
    }

    public @Nullable UUID getEntryId() {
        return this.entryId;
    }

    public void setDocumentId(@Nullable UUID documentId) {
        this.documentId = documentId;
    }

    public void setEntryId(@Nullable UUID entryId) {
        this.entryId = entryId;
    }

    public @Nullable EmedDocumentType getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(@Nullable EmedDocumentType documentType) {
        this.documentType = documentType;
    }

    public @Nullable EmedEntryType getEntryType() {
        return this.entryType;
    }

    public void setEntryType(@Nullable EmedEntryType entryType) {
        this.entryType = entryType;
    }

    public String toString() {
        return "EmedReference{documentId=" + this.documentId + ", entryId=" + this.entryId + ", documentType=" + this.documentType + ", entryType=" + this.entryType + "}";
    }
}

