/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.model.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Period;
import org.projecthusky.fhir.emed.ch.common.enums.RouteOfAdministrationEdqm;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedEprDosage;
import org.projecthusky.fhir.emed.ch.epr.enums.TimingEventAmbu;
import org.projecthusky.fhir.emed.ch.epr.model.common.AmountPerDuration;
import org.projecthusky.fhir.emed.ch.epr.model.common.AmountQuantity;
import org.projecthusky.fhir.emed.ch.epr.model.common.DosageIntake;
import org.projecthusky.fhir.emed.ch.epr.model.common.Dose;

public record EffectiveDosageInstructions(@Nullable String patientInstructions, String narrative, boolean isAsNeeded, List<DosageIntake> intakes, @Nullable Dose simpleDose, @Nullable List<TimingEventAmbu> simpleEventTimings, @Nullable String site, @Nullable RouteOfAdministrationEdqm routeOfAdministration, @Nullable Period period, @Nullable AmountPerDuration maxDosePerPeriod, @Nullable AmountQuantity maxDosePerAdministration) {
    public boolean hasPatientInstructions() {
        return this.patientInstructions != null;
    }

    public boolean hasRouteOfAdministration() {
        return this.routeOfAdministration != null;
    }

    public boolean hasIntakes() {
        return !this.intakes.isEmpty();
    }

    public boolean hasMaxDose() {
        return this.maxDosePerPeriod != null || this.maxDosePerAdministration != null;
    }

    public boolean hasSimpleDose() {
        return this.simpleDose != null;
    }

    public boolean hasSimpleEventTimings() {
        return this.simpleEventTimings != null;
    }

    public @Nullable DosageIntake getMornIntake() {
        return this.getIntake(TimingEventAmbu.MORNING);
    }

    public @Nullable DosageIntake getNoonIntake() {
        return this.getIntake(TimingEventAmbu.NOON);
    }

    public @Nullable DosageIntake getEveIntake() {
        return this.getIntake(TimingEventAmbu.EVENING);
    }

    public @Nullable DosageIntake getNightIntake() {
        return this.getIntake(TimingEventAmbu.NIGHT);
    }

    public @Nullable DosageIntake getIntake(TimingEventAmbu eventTiming) {
        return this.intakes.stream().filter(intake -> intake.eventTiming() == eventTiming).findAny().orElse(null);
    }

    public boolean isRegular() {
        return !this.isAsNeeded();
    }

    public static EffectiveDosageInstructions fromDosages(ChEmedEprDosage baseDosage, List<ChEmedEprDosage> additionalDosages) {
        String patientInstructions = baseDosage.getPatientInstruction();
        String narrative = baseDosage.getText();
        boolean isAsNeeded = baseDosage.isAsNeeded();
        String site = baseDosage.getSiteText();
        RouteOfAdministrationEdqm routeOfAdministration = baseDosage.resolveRouteOfAdministration();
        Period period = baseDosage.getBoundsPeriod();
        AmountPerDuration maxDosePerPeriod = baseDosage.resolveMaxDosePerPeriod();
        AmountQuantity maxDosePerAdministration = baseDosage.resolveMaxDosePerAdministration();
        ArrayList<DosageIntake> intakes = new ArrayList<DosageIntake>(0);
        Consumer<ChEmedEprDosage> processIntakes = dosage -> {
            Dose dose = dosage.resolveDose();
            if (dose == null || dose.isQuantity() && "0".equals(dose.quantity().value())) {
                return;
            }
            for (TimingEventAmbu eventTiming : dosage.resolveWhen()) {
                intakes.add(new DosageIntake(eventTiming, dose));
            }
        };
        processIntakes.accept(baseDosage);
        for (ChEmedEprDosage additionalDosage : additionalDosages) {
            processIntakes.accept(additionalDosage);
        }
        Dose simpleDose = null;
        List<TimingEventAmbu> simpleEventTimings = null;
        if (intakes.isEmpty()) {
            if (baseDosage.hasDoseAndRate() && baseDosage.getDoseAndRateFirstRep().hasDoseQuantity()) {
                simpleDose = baseDosage.resolveDose();
            }
            if (baseDosage.hasTiming() && baseDosage.getTiming().hasRepeat() && baseDosage.getTiming().getRepeat().hasWhen()) {
                simpleEventTimings = baseDosage.resolveWhen();
            }
        }
        return new EffectiveDosageInstructions(patientInstructions, narrative, isAsNeeded, intakes, simpleDose, simpleEventTimings, site, routeOfAdministration, period, maxDosePerPeriod, maxDosePerAdministration);
    }
}

