/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.model.common;

import java.util.Objects;
import org.hl7.fhir.r4.model.Quantity;
import org.projecthusky.fhir.emed.ch.epr.enums.ChEmedEprTimeUnit;

public record Duration(int value, ChEmedEprTimeUnit unit) {
    public Duration(int value, ChEmedEprTimeUnit unit) {
        if (value < 1) {
            throw new IllegalArgumentException("Duration: The value must be at least 1");
        }
        this.value = value;
        this.unit = Objects.requireNonNull(unit);
    }

    public static Duration fromQuantity(Quantity quantity) {
        if (!quantity.hasCode()) {
            throw new IllegalArgumentException("Duration: Missing code in quantity");
        }
        if (!quantity.hasValue()) {
            throw new IllegalArgumentException("Duration: Missing value in quantity");
        }
        if (!quantity.hasSystem()) {
            throw new IllegalArgumentException("Duration: Missing system in quantity");
        }
        ChEmedEprTimeUnit unit = ChEmedEprTimeUnit.getEnum(quantity.getCode());
        if (unit == null || !quantity.getSystem().equals(unit.getCodeSystemId())) {
            throw new IllegalArgumentException("Duration: Invalid code in quantity");
        }
        return new Duration(quantity.getValueElement().getValueAsInteger(), unit);
    }
}

