/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.model.common;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.projecthusky.fhir.emed.ch.epr.model.common.AmountQuantity;

public record Dose(@Nullable AmountQuantity quantity, @Nullable AmountQuantity low, @Nullable AmountQuantity high) {
    public Dose(@Nullable AmountQuantity quantity, @Nullable AmountQuantity low, @Nullable AmountQuantity high) {
        if (quantity == null && low == null && high == null) {
            throw new IllegalArgumentException("Dose: Either the quantity or the low/high shall be specified");
        }
        if (quantity != null && (low != null || high != null)) {
            throw new IllegalArgumentException("Dose: Either the quantity or the low/high shall be specified");
        }
    }

    public boolean isRange() {
        return !this.isQuantity();
    }

    public boolean isQuantity() {
        return this.quantity != null;
    }

    public static Dose fromQuantityAndRange(Quantity quantity, Range range) {
        if (quantity.isEmpty() && range.isEmpty()) {
            throw new IllegalArgumentException("Dose: Either the quantity or range shall be specified");
        }
        if (!quantity.isEmpty() && !range.isEmpty()) {
            throw new IllegalArgumentException("Dose: Either the quantity or range shall be specified");
        }
        if (!quantity.isEmpty()) {
            return new Dose(AmountQuantity.fromQuantity(quantity), null, null);
        }
        return new Dose(null, AmountQuantity.fromQuantity(range.getLow()), AmountQuantity.fromQuantity(range.getHigh()));
    }
}

