/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.model.common;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprDevice;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprOrganization;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPatient;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitioner;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprPractitionerRole;
import org.projecthusky.fhir.emed.ch.epr.resource.ChEmedEprRelatedPerson;

public class Author {
    private @Nullable ChEmedEprPractitioner practitioner;
    private @Nullable ChEmedEprPractitionerRole practitionerRole;
    private @Nullable ChEmedEprDevice device;
    private @Nullable ChEmedEprRelatedPerson relatedPerson;
    private @Nullable ChEmedEprPatient patient;
    private @Nullable ChEmedEprOrganization organization;

    public Author(IBaseResource resource) {
        if (resource instanceof ChEmedEprDevice) {
            ChEmedEprDevice device = (ChEmedEprDevice)resource;
            this.setDevice(device);
        } else if (resource instanceof ChEmedEprOrganization) {
            ChEmedEprOrganization organization = (ChEmedEprOrganization)resource;
            this.setOrganization(organization);
        } else if (resource instanceof ChEmedEprPatient) {
            ChEmedEprPatient patient = (ChEmedEprPatient)resource;
            this.setPatient(patient);
        } else if (resource instanceof ChEmedEprPractitioner) {
            ChEmedEprPractitioner practitioner = (ChEmedEprPractitioner)resource;
            this.setPractitioner(practitioner);
        } else if (resource instanceof ChEmedEprPractitionerRole) {
            ChEmedEprPractitionerRole practitionerRole = (ChEmedEprPractitionerRole)resource;
            this.setPractitionerRole(practitionerRole);
        } else if (resource instanceof ChEmedEprRelatedPerson) {
            ChEmedEprRelatedPerson relatedPerson = (ChEmedEprRelatedPerson)resource;
            this.setRelatedPerson(relatedPerson);
        } else {
            throw new IllegalArgumentException("Passed resource is not a supported author: " + resource.getClass().getName());
        }
    }

    public @Nullable IBaseResource getFirstNonNull() {
        if (this.device != null) {
            return this.device;
        }
        if (this.organization != null) {
            return this.organization;
        }
        if (this.patient != null) {
            return this.patient;
        }
        if (this.practitioner != null) {
            return this.practitioner;
        }
        if (this.practitionerRole != null) {
            return this.practitionerRole;
        }
        if (this.relatedPerson != null) {
            return this.relatedPerson;
        }
        return null;
    }

    public @Nullable ChEmedEprPractitioner getPractitioner() {
        return this.practitioner;
    }

    public @Nullable ChEmedEprPractitionerRole getPractitionerRole() {
        return this.practitionerRole;
    }

    public @Nullable ChEmedEprDevice getDevice() {
        return this.device;
    }

    public @Nullable ChEmedEprRelatedPerson getRelatedPerson() {
        return this.relatedPerson;
    }

    public @Nullable ChEmedEprPatient getPatient() {
        return this.patient;
    }

    public @Nullable ChEmedEprOrganization getOrganization() {
        return this.organization;
    }

    public void setPractitioner(@Nullable ChEmedEprPractitioner practitioner) {
        this.practitioner = practitioner;
    }

    public void setPractitionerRole(@Nullable ChEmedEprPractitionerRole practitionerRole) {
        this.practitionerRole = practitionerRole;
    }

    public void setDevice(@Nullable ChEmedEprDevice device) {
        this.device = device;
    }

    public void setRelatedPerson(@Nullable ChEmedEprRelatedPerson relatedPerson) {
        this.relatedPerson = relatedPerson;
    }

    public void setPatient(@Nullable ChEmedEprPatient patient) {
        this.patient = patient;
    }

    public void setOrganization(@Nullable ChEmedEprOrganization organization) {
        this.organization = organization;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Author)) {
            return false;
        }
        Author other = (Author)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ChEmedEprPractitioner this$practitioner = this.getPractitioner();
        ChEmedEprPractitioner other$practitioner = other.getPractitioner();
        if (this$practitioner == null ? other$practitioner != null : !((Object)((Object)this$practitioner)).equals((Object)other$practitioner)) {
            return false;
        }
        ChEmedEprPractitionerRole this$practitionerRole = this.getPractitionerRole();
        ChEmedEprPractitionerRole other$practitionerRole = other.getPractitionerRole();
        if (this$practitionerRole == null ? other$practitionerRole != null : !((Object)((Object)this$practitionerRole)).equals((Object)other$practitionerRole)) {
            return false;
        }
        ChEmedEprDevice this$device = this.getDevice();
        ChEmedEprDevice other$device = other.getDevice();
        if (this$device == null ? other$device != null : !((Object)((Object)this$device)).equals((Object)other$device)) {
            return false;
        }
        ChEmedEprRelatedPerson this$relatedPerson = this.getRelatedPerson();
        ChEmedEprRelatedPerson other$relatedPerson = other.getRelatedPerson();
        if (this$relatedPerson == null ? other$relatedPerson != null : !((Object)((Object)this$relatedPerson)).equals((Object)other$relatedPerson)) {
            return false;
        }
        ChEmedEprPatient this$patient = this.getPatient();
        ChEmedEprPatient other$patient = other.getPatient();
        if (this$patient == null ? other$patient != null : !((Object)((Object)this$patient)).equals((Object)other$patient)) {
            return false;
        }
        ChEmedEprOrganization this$organization = this.getOrganization();
        ChEmedEprOrganization other$organization = other.getOrganization();
        return !(this$organization == null ? other$organization != null : !((Object)((Object)this$organization)).equals((Object)other$organization));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Author;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ChEmedEprPractitioner $practitioner = this.getPractitioner();
        result = result * 59 + ($practitioner == null ? 43 : ((Object)((Object)$practitioner)).hashCode());
        ChEmedEprPractitionerRole $practitionerRole = this.getPractitionerRole();
        result = result * 59 + ($practitionerRole == null ? 43 : ((Object)((Object)$practitionerRole)).hashCode());
        ChEmedEprDevice $device = this.getDevice();
        result = result * 59 + ($device == null ? 43 : ((Object)((Object)$device)).hashCode());
        ChEmedEprRelatedPerson $relatedPerson = this.getRelatedPerson();
        result = result * 59 + ($relatedPerson == null ? 43 : ((Object)((Object)$relatedPerson)).hashCode());
        ChEmedEprPatient $patient = this.getPatient();
        result = result * 59 + ($patient == null ? 43 : ((Object)((Object)$patient)).hashCode());
        ChEmedEprOrganization $organization = this.getOrganization();
        result = result * 59 + ($organization == null ? 43 : ((Object)((Object)$organization)).hashCode());
        return result;
    }

    public String toString() {
        return "Author(practitioner=" + this.getPractitioner() + ", practitionerRole=" + this.getPractitionerRole() + ", device=" + this.getDevice() + ", relatedPerson=" + this.getRelatedPerson() + ", patient=" + this.getPatient() + ", organization=" + this.getOrganization() + ")";
    }
}

