/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.model.common;

import java.util.Objects;
import org.hl7.fhir.r4.model.Quantity;
import org.projecthusky.fhir.emed.ch.epr.enums.RegularUnitCodeAmbu;

public record AmountQuantity(String value, RegularUnitCodeAmbu unit) {
    public AmountQuantity(String value, RegularUnitCodeAmbu unit) {
        this.value = Objects.requireNonNull(value);
        this.unit = Objects.requireNonNull(unit);
    }

    public static AmountQuantity fromQuantity(Quantity quantity) {
        if (!quantity.hasCode()) {
            throw new IllegalArgumentException("AmountQuantity: Missing code in quantity");
        }
        if (!quantity.hasValue()) {
            throw new IllegalArgumentException("AmountQuantity: Missing value in quantity");
        }
        if (!quantity.hasSystem()) {
            throw new IllegalArgumentException("AmountQuantity: Missing system in quantity");
        }
        RegularUnitCodeAmbu unit = RegularUnitCodeAmbu.getEnum(quantity.getCode());
        if (unit == null || !quantity.getSystem().equals(unit.getCodeSystemId())) {
            throw new IllegalArgumentException("AmountQuantity: Invalid code in quantity");
        }
        return new AmountQuantity(quantity.getValueElement().asStringValue(), unit);
    }
}

