/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.model.common;

import java.util.Objects;
import org.hl7.fhir.r4.model.Ratio;
import org.projecthusky.fhir.emed.ch.epr.model.common.AmountQuantity;
import org.projecthusky.fhir.emed.ch.epr.model.common.Duration;

public record AmountPerDuration(AmountQuantity amount, Duration duration) {
    public AmountPerDuration(AmountQuantity amount, Duration duration) {
        this.amount = Objects.requireNonNull(amount);
        this.duration = Objects.requireNonNull(duration);
    }

    public static AmountPerDuration fromRatio(Ratio ratio) {
        AmountQuantity amount = AmountQuantity.fromQuantity(ratio.getNumerator());
        Duration duration = Duration.fromQuantity(ratio.getDenominator());
        return new AmountPerDuration(amount, duration);
    }
}

