/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum TimingEventAmbu implements ValueSetEnumInterface
{
    EVENING("EVE", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Evening", "Evening", "Abend", "Soir\u00e9e", "Sera"),
    MORNING("MORN", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Morning", "Morning", "Morgen", "Matin\u00e9e", "Mattina"),
    NIGHT("NIGHT", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Night", "Night", "Nacht", "Nuit", "Notte"),
    NOON("NOON", "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing", "Noon", "Noon", "Mittag", "Midi", "Mezzogiorno");

    public static final String EVENING_CODE = "EVE";
    public static final String MORNING_CODE = "MORN";
    public static final String NIGHT_CODE = "NIGHT";
    public static final String NOON_CODE = "NOON";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.77.12.11.2";
    public static final String VALUE_SET_NAME = "TimingEventAmbu";
    public static final String CODE_SYSTEM_ID = "http://fhir.ch/ig/ch-emed/CodeSystem/event-timing";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable TimingEventAmbu getEnum(@Nullable String code) {
        for (TimingEventAmbu x : TimingEventAmbu.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(TimingEventAmbu.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (TimingEventAmbu x : TimingEventAmbu.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private TimingEventAmbu(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

