/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.CodeableConcept;
import org.hl7.fhir.r4.model.Coding;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;
import org.projecthusky.fhir.structures.utils.FhirValueSetEnumInterface;

public enum SubstanceAdministrationSubstitutionCode implements ValueSetEnumInterface,
FhirValueSetEnumInterface
{
    EQUIVALENT("E", "http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution", "equivalent", "equivalent", "\u00c4quivalent", "\u00e9quivalent", "equivalente"),
    NONE("N", "http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution", "none", "none", "nicht autorisiert", "non autoris\u00e9", "non autorizzato");

    public static final String EQUIVALENT_CODE = "E";
    public static final String NONE_CODE = "N";
    public static final String VALUE_SET_ID = "substance-admin-substitution-code";
    public static final String VALUE_SET_NAME = "SubstanceAdministrationSubstitutionCode";
    public static final String CODE_SYSTEM_ID = "http://terminology.hl7.org/CodeSystem/v3-substanceAdminSubstitution";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable SubstanceAdministrationSubstitutionCode getEnum(@Nullable String code) {
        for (SubstanceAdministrationSubstitutionCode x : SubstanceAdministrationSubstitutionCode.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(SubstanceAdministrationSubstitutionCode.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (SubstanceAdministrationSubstitutionCode x : SubstanceAdministrationSubstitutionCode.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable SubstanceAdministrationSubstitutionCode fromCoding(Coding coding) {
        for (SubstanceAdministrationSubstitutionCode x : SubstanceAdministrationSubstitutionCode.values()) {
            if (!x.isEqualTo(coding)) continue;
            return x;
        }
        return null;
    }

    private SubstanceAdministrationSubstitutionCode(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }

    public Coding getCoding() {
        return new Coding(this.codeSystem, this.code, this.getDisplayName());
    }

    public CodeableConcept getCodeableConcept() {
        return new CodeableConcept(this.getCoding());
    }

    public boolean isEqualTo(Coding coding) {
        return Objects.equals(this.code, coding.getCode()) && Objects.equals(this.codeSystem, coding.getSystem());
    }
}

