/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum RouteOfAdministrationAmbu implements ValueSetEnumInterface
{
    AURICULAR_USE("20001000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Auricular use", "Auricular use", "Anwendung am Ohr", "Voie auriculaire", "Uso auricolare"),
    BUCCAL_USE("20002500", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Buccal use", "Buccal use", "Buccale Anwendung", "Voie buccogingivale", "Somministrazione buccale"),
    CUTANEOUS_USE("20003000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Cutaneous use", "Cutaneous use", "Anwendung auf der Haut", "Voie cutan\u00e9e", "Uso cutaneo"),
    DENTAL_USE("20004000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Dental use", "Dental use", "dentale Anwendung", "Voie dentaire", "Uso dentale"),
    ENDOTRACHEOPULMONARY_USE("20008000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Endotracheopulmonary use", "Endotracheopulmonary use", "endotracheopulmonale Anwendung", "Voie endotrach\u00e9obronchique", "Uso endotracheobronchiale"),
    EPILESIONAL_USE("20010000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Epilesional use", "Epilesional use", "zum Auftragen auf die Wunde", "Voie \u00e9pil\u00e9sionnelle", "Uso epilesionale"),
    GASTRIC_USE("20013500", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Gastric use", "Gastric use", "zur Anwendung mittels Magensonde", "Voie gastrique", "Uso gastrico"),
    GASTROENTERAL_USE("20013000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Gastroenteral use", "Gastroenteral use", "gastrointestinale Anwendung", "Voie gastro-ent\u00e9rale", "Uso gastrointestinale"),
    GINGIVAL_USE("20014000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Gingival use", "Gingival use", "Anwendung am Zahnfleisch", "Voie gingivale", "Uso gengivale"),
    HAEMODIALYSIS("20015000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Haemodialysis", "Haemodialysis", "H\u00e4modialyse", "H\u00e9modialyse", "Emodialisi"),
    INHALATION_USE("20020000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Inhalation use", "Inhalation use", "zur Inhalation", "Voie inhal\u00e9e", "Uso inalatorio"),
    INTESTINAL_USE("20021000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Intestinal use", "Intestinal use", "intestinale Anwendung", "Voie intestinale", "Uso intestinale"),
    INTRAEPIDERMAL_USE("20031500", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Intraepidermal use", "Intraepidermal use", "intraepidermale Anwendung", "Voie intra\u00e9pidermique", "Uso intraepidermico"),
    INTRALESIONAL_USE("20032000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Intralesional use", "Intralesional use", "intral\u00e4sionale Anwendung", "Voie intral\u00e9sionnelle", "Uso intralesionale"),
    INTRAMUSCULAR_USE("20035000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Intramuscular use", "Intramuscular use", "intramuskul\u00e4re Anwendung", "Voie intramusculaire", "Uso intramuscolare"),
    INTRAPLEURAL_USE("20039000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Intrapleural use", "Intrapleural use", "intrapleurale Anwendung", "Voie intrapleurale", "Uso intrapleurico"),
    INTRAUTERINE_USE("20044000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Intrauterine use", "Intrauterine use", "intrauterine Anwendung", "Voie intra-ut\u00e9rine", "Uso intrauterino"),
    INTRAVENOUS_USE("20045000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Intravenous use", "Intravenous use", "intraven\u00f6se Anwendung", "Voie intraveineuse", "Uso endovenoso"),
    INTRAVESICAL_USE("20046000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Intravesical use", "Intravesical use", "intravesikale Anwendung", "Voie intrav\u00e9sicale", "Uso endovescicale"),
    NASAL_USE("20049000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Nasal use", "Nasal use", "nasale Anwendung", "Voie nasale", "Uso nasale"),
    OCULAR_USE("20051000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Ocular use", "Ocular use", "Anwendung am Auge", "Voie ophtalmique", "Uso oftalmico"),
    ORAL_USE("20053000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Oral use", "Oral use", "zum Einnehmen", "Voie orale", "Uso orale"),
    OROMUCOSAL_USE("20054000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Oromucosal use", "Oromucosal use", "Anwendung in der Mundh\u00f6hle", "Voie buccale", "Per mucosa orale"),
    OROPHARYNGEAL_USE("20055000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Oropharyngeal use", "Oropharyngeal use", "zur Anwendung im Mund- und Rachenraum", "Voie oropharyng\u00e9e", "Uso orofaringeo"),
    RECTAL_USE("20061000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Rectal use", "Rectal use", "rektale Anwendung", "Voie rectale", "Uso rettale"),
    SUBCUTANEOUS_USE("20066000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Subcutaneous use", "Subcutaneous use", "subkutane Anwendung", "Voie sous-cutan\u00e9e", "Uso sottocutaneo"),
    SUBLINGUAL_USE("20067000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Sublingual use", "Sublingual use", "Sublingual", "Voie sublinguale", "Uso sublinguale"),
    TRANSDERMAL_USE("20070000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Transdermal use", "Transdermal use", "transdermale Anwendung", "Voie transdermique", "Uso transdermico"),
    URETHRAL_USE("20071000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Urethral use", "Urethral use", "Anwendung in der Harnr\u00f6hre", "Voie ur\u00e9trale", "Uso uretrale"),
    VAGINAL_USE("20072000", "urn:oid:0.4.0.127.0.16.1.1.2.1", "Vaginal use", "Vaginal use", "vaginale Anwendung", "Voie vaginale", "Uso vaginale");

    public static final String AURICULAR_USE_CODE = "20001000";
    public static final String BUCCAL_USE_CODE = "20002500";
    public static final String CUTANEOUS_USE_CODE = "20003000";
    public static final String DENTAL_USE_CODE = "20004000";
    public static final String ENDOTRACHEOPULMONARY_USE_CODE = "20008000";
    public static final String EPILESIONAL_USE_CODE = "20010000";
    public static final String GASTRIC_USE_CODE = "20013500";
    public static final String GASTROENTERAL_USE_CODE = "20013000";
    public static final String GINGIVAL_USE_CODE = "20014000";
    public static final String HAEMODIALYSIS_CODE = "20015000";
    public static final String INHALATION_USE_CODE = "20020000";
    public static final String INTESTINAL_USE_CODE = "20021000";
    public static final String INTRAEPIDERMAL_USE_CODE = "20031500";
    public static final String INTRALESIONAL_USE_CODE = "20032000";
    public static final String INTRAMUSCULAR_USE_CODE = "20035000";
    public static final String INTRAPLEURAL_USE_CODE = "20039000";
    public static final String INTRAUTERINE_USE_CODE = "20044000";
    public static final String INTRAVENOUS_USE_CODE = "20045000";
    public static final String INTRAVESICAL_USE_CODE = "20046000";
    public static final String NASAL_USE_CODE = "20049000";
    public static final String OCULAR_USE_CODE = "20051000";
    public static final String ORAL_USE_CODE = "20053000";
    public static final String OROMUCOSAL_USE_CODE = "20054000";
    public static final String OROPHARYNGEAL_USE_CODE = "20055000";
    public static final String RECTAL_USE_CODE = "20061000";
    public static final String SUBCUTANEOUS_USE_CODE = "20066000";
    public static final String SUBLINGUAL_USE_CODE = "20067000";
    public static final String TRANSDERMAL_USE_CODE = "20070000";
    public static final String URETHRAL_USE_CODE = "20071000";
    public static final String VAGINAL_USE_CODE = "20072000";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.127.77.12.11.1";
    public static final String VALUE_SET_NAME = "RouteOfAdministrationAmbu";
    public static final String CODE_SYSTEM_ID = "urn:oid:0.4.0.127.0.16.1.1.2.1";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable RouteOfAdministrationAmbu getEnum(@Nullable String code) {
        for (RouteOfAdministrationAmbu x : RouteOfAdministrationAmbu.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(RouteOfAdministrationAmbu.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (RouteOfAdministrationAmbu x : RouteOfAdministrationAmbu.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private RouteOfAdministrationAmbu(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

