/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.LanguageCode;

public enum CompositionTitle {
    MTP("Medication Treatment Plan", "Therapieentscheid Medikation", "D\u00e9cision th\u00e9rapeutique relative \u00e0 la m\u00e9dication", "Decisione terapeutica di trattamento farmacologico"),
    PRE("Prescription", "Rezept", "Ordonnance", "Ricetta"),
    DIS("Dispense", "Abgabe", "Remise", "Dispensazione"),
    PADV("Pharmaceutical Advice", "Kommentar zur Medikation", "Commentaire relatif \u00e0 la m\u00e9dication", "Commento sulla terapia farmacologica"),
    PML("Medication List", "Medikationsliste", "Liste de m\u00e9dication", "Elenco delle terapie farmacologiche"),
    PMLC("Medication Card", "Medikationsplan", "Plan de m\u00e9dication", "Piano farmacologico");

    private final @NonNull String[] displayNames = new String[4];

    private CompositionTitle(String displayNameEn, String displayNameDe, String displayNameFr, String displayNameIt) {
        this.displayNames[0] = Objects.requireNonNull(displayNameEn);
        this.displayNames[1] = Objects.requireNonNull(displayNameDe);
        this.displayNames[2] = Objects.requireNonNull(displayNameFr);
        this.displayNames[3] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[0];
            case LanguageCode.GERMAN -> this.displayNames[1];
            case LanguageCode.FRENCH -> this.displayNames[2];
            case LanguageCode.ITALIAN -> this.displayNames[3];
            default -> "TOTRANSLATE";
        };
    }
}

