/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.enums;

import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.projecthusky.common.enums.CodeSystems;
import org.projecthusky.common.enums.LanguageCode;
import org.projecthusky.common.enums.ValueSetEnumInterface;

public enum ChEmedEprTimeUnit implements ValueSetEnumInterface
{
    A("a", "http://unitsofmeasure.org", "Year", "a", "a", "a", "a"),
    SEC("s", "http://unitsofmeasure.org", "Second", "sec", "sec", "sec", "sec"),
    MIN("min", "http://unitsofmeasure.org", "Minute", "min", "min", "min", "min"),
    H("h", "http://unitsofmeasure.org", "Hour", "h", "h", "h", "h"),
    D("d", "http://unitsofmeasure.org", "Day", "d", "d", "d", "d"),
    MO("mo", "http://unitsofmeasure.org", "Month", "mo", "mo", "mo", "mo");

    public static final String A_CODE = "a";
    public static final String SEC_CODE = "s";
    public static final String MIN_CODE = "min";
    public static final String H_CODE = "h";
    public static final String D_CODE = "d";
    public static final String MO_CODE = "mo";
    public static final String VALUE_SET_ID = "2.16.756.5.30.1.1.11.83";
    public static final String VALUE_SET_NAME = "UnitCode";
    private final @NonNull String code;
    private final @NonNull String codeSystem;
    private final @NonNull String[] displayNames;

    public static @Nullable ChEmedEprTimeUnit getEnum(@Nullable String code) {
        for (ChEmedEprTimeUnit x : ChEmedEprTimeUnit.values()) {
            if (!x.getCodeValue().equals(code)) continue;
            return x;
        }
        return null;
    }

    public static boolean isEnumOfValueSet(@Nullable String enumName) {
        if (enumName == null) {
            return false;
        }
        try {
            Enum.valueOf(ChEmedEprTimeUnit.class, enumName);
            return true;
        }
        catch (IllegalArgumentException ex) {
            return false;
        }
    }

    public static boolean isInValueSet(@Nullable String codeValue) {
        for (ChEmedEprTimeUnit x : ChEmedEprTimeUnit.values()) {
            if (!x.getCodeValue().equals(codeValue)) continue;
            return true;
        }
        return false;
    }

    private ChEmedEprTimeUnit(@NonNull String code, @NonNull String codeSystem, @NonNull String displayName, @NonNull String displayNameEn, @NonNull String displayNameDe, String displayNameFr, String displayNameIt) {
        this.code = Objects.requireNonNull(code);
        this.codeSystem = Objects.requireNonNull(codeSystem);
        this.displayNames = new String[5];
        this.displayNames[0] = Objects.requireNonNull(displayName);
        this.displayNames[1] = Objects.requireNonNull(displayNameEn);
        this.displayNames[2] = Objects.requireNonNull(displayNameDe);
        this.displayNames[3] = Objects.requireNonNull(displayNameFr);
        this.displayNames[4] = Objects.requireNonNull(displayNameIt);
    }

    public @NonNull String getCodeSystemId() {
        return this.codeSystem;
    }

    public @NonNull String getCodeSystemName() {
        CodeSystems codeSystem = CodeSystems.getEnum((String)this.codeSystem);
        if (codeSystem != null) {
            return codeSystem.getCodeSystemName();
        }
        return "";
    }

    public @NonNull String getCodeValue() {
        return this.code;
    }

    public @NonNull String getDisplayName(@Nullable LanguageCode languageCode) {
        if (languageCode == null) {
            return this.displayNames[0];
        }
        return switch (languageCode) {
            case LanguageCode.ENGLISH -> this.displayNames[1];
            case LanguageCode.GERMAN -> this.displayNames[2];
            case LanguageCode.FRENCH -> this.displayNames[3];
            case LanguageCode.ITALIAN -> this.displayNames[4];
            default -> "TOTRANSLATE";
        };
    }

    public @NonNull String getValueSetId() {
        return VALUE_SET_ID;
    }

    public @NonNull String getValueSetName() {
        return VALUE_SET_NAME;
    }
}

