/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.datatypes;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Ratio;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedQuantityWithEmedUnits;

public class ChEmedRatioWithEmedUnits
extends Ratio {
    @ExpectsValidResource
    public @Nullable ChEmedQuantityWithEmedUnits resolveNumerator() throws InvalidEmedContentException {
        if (!this.hasNumerator()) {
            return null;
        }
        Quantity numerator = this.getNumerator();
        if (numerator instanceof ChEmedQuantityWithEmedUnits) {
            ChEmedQuantityWithEmedUnits chNumerator = (ChEmedQuantityWithEmedUnits)numerator;
            return chNumerator;
        }
        throw new InvalidEmedContentException("The numerator quantity isn't of the right type.");
    }

    @ExpectsValidResource
    public @Nullable ChEmedQuantityWithEmedUnits resolveDenominator() throws InvalidEmedContentException {
        if (!this.hasDenominator()) {
            return null;
        }
        Quantity denominator = this.getDenominator();
        if (denominator instanceof ChEmedQuantityWithEmedUnits) {
            ChEmedQuantityWithEmedUnits chDenominator = (ChEmedQuantityWithEmedUnits)denominator;
            return chDenominator;
        }
        throw new InvalidEmedContentException("The denominator quantity isn't of the right type");
    }

    public ChEmedRatioWithEmedUnits setNumerator(ChEmedQuantityWithEmedUnits numerator) {
        super.setNumerator((Quantity)numerator);
        return this;
    }

    public ChEmedRatioWithEmedUnits setDenominator(ChEmedQuantityWithEmedUnits denominator) {
        super.setDenominator((Quantity)denominator);
        return this;
    }

    public ChEmedRatioWithEmedUnits copy() {
        ChEmedRatioWithEmedUnits copy = new ChEmedRatioWithEmedUnits();
        this.copyValues(copy);
        return copy;
    }
}

