/*
 * Decompiled with CFR 0.152.
 */
package org.projecthusky.fhir.emed.ch.epr.datatypes;

import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Range;
import org.projecthusky.fhir.emed.ch.common.annotation.ExpectsValidResource;
import org.projecthusky.fhir.emed.ch.common.error.InvalidEmedContentException;
import org.projecthusky.fhir.emed.ch.epr.datatypes.ChEmedQuantityWithEmedUnits;

public class ChEmedRangeWithEmedUnits
extends Range {
    @ExpectsValidResource
    public ChEmedQuantityWithEmedUnits resolveLow() throws InvalidEmedContentException {
        if (!this.hasLow()) {
            throw new InvalidEmedContentException("The low quantity is missing");
        }
        Quantity low = this.getLow();
        if (low instanceof ChEmedQuantityWithEmedUnits) {
            ChEmedQuantityWithEmedUnits chLow = (ChEmedQuantityWithEmedUnits)low;
            return chLow;
        }
        throw new InvalidEmedContentException("The low quantity isn't of the right type.");
    }

    @ExpectsValidResource
    public ChEmedQuantityWithEmedUnits resolveHigh() throws InvalidEmedContentException {
        if (!this.hasHigh()) {
            throw new InvalidEmedContentException("The high quantity is missing");
        }
        Quantity high = this.getHigh();
        if (high instanceof ChEmedQuantityWithEmedUnits) {
            ChEmedQuantityWithEmedUnits chHigh = (ChEmedQuantityWithEmedUnits)high;
            return chHigh;
        }
        throw new InvalidEmedContentException("The high quantity isn't of the right type");
    }

    public ChEmedRangeWithEmedUnits setLow(ChEmedQuantityWithEmedUnits low) {
        super.setLow((Quantity)low);
        return this;
    }

    public ChEmedRangeWithEmedUnits setHigh(ChEmedQuantityWithEmedUnits high) {
        super.setHigh((Quantity)high);
        return this;
    }

    public ChEmedRangeWithEmedUnits copy() {
        ChEmedRangeWithEmedUnits copy = new ChEmedRangeWithEmedUnits();
        this.copyValues(copy);
        return copy;
    }
}

